/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.waypoints.interfaces;

import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public interface EuclideanWaypointReadOnly
extends EuclidGeometry {
    public Point3DReadOnly getPosition();

    public Vector3DReadOnly getLinearVelocity();

    default public boolean containsNaN() {
        return this.getPosition().containsNaN() || this.getLinearVelocity().containsNaN();
    }

    default public double getPositionX() {
        return this.getPosition().getX();
    }

    default public double getPositionY() {
        return this.getPosition().getY();
    }

    default public double getPositionZ() {
        return this.getPosition().getZ();
    }

    default public double getLinearVelocityX() {
        return this.getLinearVelocity().getX();
    }

    default public double getLinearVelocityY() {
        return this.getLinearVelocity().getY();
    }

    default public double getLinearVelocityZ() {
        return this.getLinearVelocity().getZ();
    }

    default public double positionDistance(EuclideanWaypointReadOnly other) {
        return this.getPosition().distance(other.getPosition());
    }

    default public boolean equals(EuclidGeometry geometry) {
        if (geometry == this) {
            return true;
        }
        if (geometry == null) {
            return false;
        }
        if (!(geometry instanceof EuclideanWaypointReadOnly)) {
            return false;
        }
        EuclideanWaypointReadOnly other = (EuclideanWaypointReadOnly)geometry;
        if (!this.getPosition().equals((EuclidGeometry)other.getPosition())) {
            return false;
        }
        return this.getLinearVelocity().equals((EuclidGeometry)other.getLinearVelocity());
    }

    default public boolean epsilonEquals(EuclidGeometry geometry, double epsilon) {
        if (geometry == this) {
            return true;
        }
        if (geometry == null) {
            return false;
        }
        if (!(geometry instanceof EuclideanWaypointReadOnly)) {
            return false;
        }
        EuclideanWaypointReadOnly other = (EuclideanWaypointReadOnly)geometry;
        if (!this.getPosition().epsilonEquals((EuclidGeometry)other.getPosition(), epsilon)) {
            return false;
        }
        return this.getLinearVelocity().epsilonEquals((EuclidGeometry)other.getLinearVelocity(), epsilon);
    }

    default public boolean geometricallyEquals(EuclidGeometry geometry, double epsilon) {
        if (geometry == this) {
            return true;
        }
        if (geometry == null) {
            return false;
        }
        if (!(geometry instanceof EuclideanWaypointReadOnly)) {
            return false;
        }
        EuclideanWaypointReadOnly other = (EuclideanWaypointReadOnly)geometry;
        if (!this.getPosition().geometricallyEquals((EuclidGeometry)other.getPosition(), epsilon)) {
            return false;
        }
        return this.getLinearVelocity().geometricallyEquals((EuclidGeometry)other.getLinearVelocity(), epsilon);
    }

    default public String toString(String format) {
        return String.format("Euclidean waypoint: [position=%s, linear velocity=%s]", EuclidCoreIOTools.getTuple3DString((String)format, (Tuple3DReadOnly)this.getPosition()), EuclidCoreIOTools.getTuple3DString((String)format, (Tuple3DReadOnly)this.getLinearVelocity()));
    }
}

