/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.waypoints.interfaces;

import us.ihmc.euclid.interfaces.Clearable;
import us.ihmc.euclid.interfaces.Transformable;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.EuclideanWaypointReadOnly;

public interface EuclideanWaypointBasics
extends Transformable,
Clearable,
EuclideanWaypointReadOnly {
    public Point3DBasics getPosition();

    public Vector3DBasics getLinearVelocity();

    default public void setToNaN() {
        this.getPosition().setToNaN();
        this.getLinearVelocity().setToNaN();
    }

    default public void setToZero() {
        this.getPosition().setToZero();
        this.getLinearVelocity().setToZero();
    }

    @Override
    default public boolean containsNaN() {
        return EuclideanWaypointReadOnly.super.containsNaN();
    }

    default public void set(Point3DReadOnly position, Vector3DReadOnly linearVelocity) {
        this.getPosition().set((Tuple3DReadOnly)position);
        this.getLinearVelocity().set((Tuple3DReadOnly)linearVelocity);
    }

    default public void set(EuclideanWaypointReadOnly other) {
        this.getPosition().set((Tuple3DReadOnly)other.getPosition());
        this.getLinearVelocity().set((Tuple3DReadOnly)other.getLinearVelocity());
    }

    default public void applyTransform(Transform transform) {
        this.getPosition().applyTransform(transform);
        this.getLinearVelocity().applyTransform(transform);
    }

    default public void applyInverseTransform(Transform transform) {
        this.getPosition().applyInverseTransform(transform);
        this.getLinearVelocity().applyInverseTransform(transform);
    }
}

