/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.waypoints;

import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.robotics.math.trajectories.waypoints.YoFrameEuclideanWaypoint;
import us.ihmc.robotics.math.trajectories.waypoints.YoFrameSO3Waypoint;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.FixedFrameEuclideanWaypointBasics;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.FixedFrameSO3WaypointBasics;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.FrameSE3WaypointBasics;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.FrameSE3WaypointReadOnly;
import us.ihmc.yoVariables.euclid.referenceFrame.interfaces.FrameIndexMap;
import us.ihmc.yoVariables.euclid.referenceFrame.interfaces.YoMutableFrameObject;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.tools.YoGeometryNameTools;
import us.ihmc.yoVariables.variable.YoLong;

public class YoFrameSE3Waypoint
implements FrameSE3WaypointBasics,
YoMutableFrameObject {
    private final YoLong frameId;
    private final FrameIndexMap frameIndexMap;
    private final YoFrameEuclideanWaypoint euclideanWaypoint;
    private final YoFrameSO3Waypoint so3Waypoint;

    public YoFrameSE3Waypoint(String namePrefix, String nameSuffix, YoRegistry registry) {
        this(namePrefix, nameSuffix, new YoLong(YoGeometryNameTools.assembleName((String[])new String[]{namePrefix, "frame", nameSuffix}), registry), (FrameIndexMap)new FrameIndexMap.FrameIndexHashMap(), registry);
    }

    public YoFrameSE3Waypoint(String namePrefix, String nameSuffix, YoLong frameIndex, FrameIndexMap frameIndexMap, YoRegistry registry) {
        this.frameId = frameIndex;
        this.frameIndexMap = frameIndexMap;
        this.euclideanWaypoint = new YoFrameEuclideanWaypoint(namePrefix, nameSuffix, this.frameId, frameIndexMap, registry);
        this.so3Waypoint = new YoFrameSO3Waypoint(namePrefix, nameSuffix, this.frameId, frameIndexMap, registry);
    }

    @Override
    public FixedFrameEuclideanWaypointBasics getEuclideanWaypoint() {
        return this.euclideanWaypoint;
    }

    @Override
    public FixedFrameSO3WaypointBasics getSO3Waypoint() {
        return this.so3Waypoint;
    }

    public ReferenceFrame getReferenceFrame() {
        return super.getReferenceFrame();
    }

    public YoLong getYoFrameIndex() {
        return this.frameId;
    }

    public FrameIndexMap getFrameIndexMap() {
        return this.frameIndexMap;
    }

    public void setReferenceFrame(ReferenceFrame referenceFrame) {
        super.setReferenceFrame(referenceFrame);
    }

    public int hashCode() {
        return EuclidHashCodeTools.toIntHashCode((Object)this.getEuclideanWaypoint(), (Object)this.getSO3Waypoint());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof FrameSE3WaypointReadOnly) {
            return this.equals((FrameSE3WaypointReadOnly)object);
        }
        return false;
    }

    public String toString() {
        return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
    }
}

