/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.waypoints;

import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.FrameEuclideanWaypointBasics;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.FrameEuclideanWaypointReadOnly;
import us.ihmc.yoVariables.euclid.referenceFrame.YoMutableFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoMutableFrameVector3D;
import us.ihmc.yoVariables.euclid.referenceFrame.interfaces.FrameIndexMap;
import us.ihmc.yoVariables.euclid.referenceFrame.interfaces.YoMutableFrameObject;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.tools.YoGeometryNameTools;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoLong;

public class YoFrameEuclideanWaypoint
implements FrameEuclideanWaypointBasics,
YoMutableFrameObject {
    private final YoLong frameId;
    private final FrameIndexMap frameIndexMap;
    private final YoMutableFramePoint3D position;
    private final YoMutableFrameVector3D linearVelocity;

    public YoFrameEuclideanWaypoint(String namePrefix, String nameSuffix, YoRegistry registry) {
        this(namePrefix, nameSuffix, new YoLong(YoGeometryNameTools.assembleName((String[])new String[]{namePrefix, "frame", nameSuffix}), registry), (FrameIndexMap)new FrameIndexMap.FrameIndexHashMap(), registry);
    }

    public YoFrameEuclideanWaypoint(String namePrefix, String nameSuffix, YoLong frameIndex, FrameIndexMap frameIndexMap, YoRegistry registry) {
        this.frameId = frameIndex;
        this.frameIndexMap = frameIndexMap;
        YoDouble px = new YoDouble(YoGeometryNameTools.createXName((String)(namePrefix + "Position"), (String)nameSuffix), registry);
        YoDouble py = new YoDouble(YoGeometryNameTools.createYName((String)(namePrefix + "Position"), (String)nameSuffix), registry);
        YoDouble pz = new YoDouble(YoGeometryNameTools.createZName((String)(namePrefix + "Position"), (String)nameSuffix), registry);
        this.position = new YoMutableFramePoint3D(px, py, pz, this.frameId, frameIndexMap);
        YoDouble vx = new YoDouble(YoGeometryNameTools.createXName((String)(namePrefix + "LinearVelocity"), (String)nameSuffix), registry);
        YoDouble vy = new YoDouble(YoGeometryNameTools.createYName((String)(namePrefix + "LinearVelocity"), (String)nameSuffix), registry);
        YoDouble vz = new YoDouble(YoGeometryNameTools.createZName((String)(namePrefix + "LinearVelocity"), (String)nameSuffix), registry);
        this.linearVelocity = new YoMutableFrameVector3D(vx, vy, vz, this.frameId, frameIndexMap);
    }

    public YoDouble getYoX() {
        return this.position.getYoX();
    }

    public YoDouble getYoY() {
        return this.position.getYoY();
    }

    public YoDouble getYoZ() {
        return this.position.getYoZ();
    }

    @Override
    public FixedFramePoint3DBasics getPosition() {
        return this.position;
    }

    @Override
    public FixedFrameVector3DBasics getLinearVelocity() {
        return this.linearVelocity;
    }

    public ReferenceFrame getReferenceFrame() {
        return super.getReferenceFrame();
    }

    public YoLong getYoFrameIndex() {
        return this.frameId;
    }

    public FrameIndexMap getFrameIndexMap() {
        return this.frameIndexMap;
    }

    public void setReferenceFrame(ReferenceFrame referenceFrame) {
        super.setReferenceFrame(referenceFrame);
    }

    public int hashCode() {
        return EuclidHashCodeTools.toIntHashCode((Object)this.getPosition(), (Object)this.getLinearVelocity());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof FrameEuclideanWaypointReadOnly) {
            return this.equals((FrameEuclideanWaypointReadOnly)object);
        }
        return false;
    }

    public String toString() {
        return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
    }
}

