/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.waypoints;

import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameQuaternionBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameFactories;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.FrameSO3WaypointBasics;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.FrameSO3WaypointReadOnly;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.SO3WaypointReadOnly;

public class FrameSO3Waypoint
implements FrameSO3WaypointBasics {
    private ReferenceFrame referenceFrame;
    private final FixedFrameQuaternionBasics orientation = EuclidFrameFactories.newFixedFrameQuaternionBasics((ReferenceFrameHolder)this);
    private final FixedFrameVector3DBasics angularVelocity = EuclidFrameFactories.newFixedFrameVector3DBasics((ReferenceFrameHolder)this);

    public FrameSO3Waypoint() {
        this.setToZero(ReferenceFrame.getWorldFrame());
    }

    public FrameSO3Waypoint(ReferenceFrame referenceFrame) {
        this.setToZero(referenceFrame);
    }

    public FrameSO3Waypoint(FrameOrientation3DReadOnly orientation, FrameVector3DReadOnly angularVelocity) {
        this.setIncludingFrame(orientation, angularVelocity);
    }

    public FrameSO3Waypoint(ReferenceFrame referenceFrame, SO3WaypointReadOnly waypoint) {
        this.setIncludingFrame(referenceFrame, waypoint);
    }

    public void setReferenceFrame(ReferenceFrame referenceFrame) {
        this.referenceFrame = referenceFrame;
    }

    public ReferenceFrame getReferenceFrame() {
        return this.referenceFrame;
    }

    @Override
    public FixedFrameQuaternionBasics getOrientation() {
        return this.orientation;
    }

    @Override
    public FixedFrameVector3DBasics getAngularVelocity() {
        return this.angularVelocity;
    }

    public int hashCode() {
        return EuclidHashCodeTools.toIntHashCode((Object)this.getOrientation(), (Object)this.getAngularVelocity());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof FrameSO3WaypointReadOnly) {
            return this.equals((FrameSO3WaypointReadOnly)object);
        }
        return false;
    }

    public String toString() {
        return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
    }
}

