/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces;

import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Tuple4DReadOnly;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.EuclideanTrajectoryPointReadOnly;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.SO3TrajectoryPointReadOnly;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.TrajectoryPointReadOnly;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.SE3WaypointReadOnly;

public interface SE3TrajectoryPointReadOnly
extends TrajectoryPointReadOnly,
SE3WaypointReadOnly,
EuclideanTrajectoryPointReadOnly,
SO3TrajectoryPointReadOnly {
    @Override
    default public boolean containsNaN() {
        return this.isTimeNaN() || SE3WaypointReadOnly.super.containsNaN();
    }

    @Override
    default public boolean equals(EuclidGeometry geometry) {
        if (geometry == this) {
            return true;
        }
        if (geometry == null) {
            return false;
        }
        if (!(geometry instanceof SE3TrajectoryPointReadOnly)) {
            return false;
        }
        SE3TrajectoryPointReadOnly other = (SE3TrajectoryPointReadOnly)geometry;
        if (!EuclidCoreTools.equals((double)this.getTime(), (double)other.getTime())) {
            return false;
        }
        if (!this.getEuclideanWaypoint().equals(other.getEuclideanWaypoint())) {
            return false;
        }
        return this.getSO3Waypoint().equals(other.getSO3Waypoint());
    }

    @Override
    default public boolean epsilonEquals(EuclidGeometry geometry, double epsilon) {
        if (geometry == this) {
            return true;
        }
        if (geometry == null) {
            return false;
        }
        if (!(geometry instanceof SE3TrajectoryPointReadOnly)) {
            return false;
        }
        SE3TrajectoryPointReadOnly other = (SE3TrajectoryPointReadOnly)geometry;
        if (!EuclidCoreTools.epsilonEquals((double)this.getTime(), (double)other.getTime(), (double)epsilon)) {
            return false;
        }
        if (!this.getEuclideanWaypoint().epsilonEquals(other.getEuclideanWaypoint(), epsilon)) {
            return false;
        }
        return this.getSO3Waypoint().epsilonEquals(other.getSO3Waypoint(), epsilon);
    }

    @Override
    default public boolean geometricallyEquals(EuclidGeometry geometry, double epsilon) {
        if (geometry == this) {
            return true;
        }
        if (geometry == null) {
            return false;
        }
        if (!(geometry instanceof SE3TrajectoryPointReadOnly)) {
            return false;
        }
        SE3TrajectoryPointReadOnly other = (SE3TrajectoryPointReadOnly)geometry;
        if (!EuclidCoreTools.epsilonEquals((double)this.getTime(), (double)other.getTime(), (double)epsilon)) {
            return false;
        }
        if (!this.getEuclideanWaypoint().geometricallyEquals(other.getEuclideanWaypoint(), epsilon)) {
            return false;
        }
        return this.getSO3Waypoint().geometricallyEquals(other.getSO3Waypoint(), epsilon);
    }

    @Override
    default public String toString(String format) {
        return String.format("SE3 trajectory point: [time=%s, position=%s, orientation=%s, linear velocity=%s, angular velocity=%s]", EuclidCoreIOTools.getStringOf(null, (String)format, (double[])new double[]{this.getTime()}), EuclidCoreIOTools.getTuple3DString((String)format, (Tuple3DReadOnly)this.getPosition()), EuclidCoreIOTools.getTuple4DString((String)format, (Tuple4DReadOnly)this.getOrientation()), EuclidCoreIOTools.getTuple3DString((String)format, (Tuple3DReadOnly)this.getLinearVelocity()), EuclidCoreIOTools.getTuple3DString((String)format, (Tuple3DReadOnly)this.getAngularVelocity()));
    }
}

