/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces;

import us.ihmc.euclid.interfaces.Transformable;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameChangeable;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.TrajectoryPointBasics;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.TrajectoryPointListBasics;

public interface FrameTrajectoryPointListBasics<T extends TrajectoryPointBasics & FrameChangeable>
extends TrajectoryPointListBasics<T>,
FrameChangeable {
    default public void clear(ReferenceFrame referenceFrame) {
        this.clear();
        this.setReferenceFrame(referenceFrame);
    }

    default public void setIncludingFrame(FrameTrajectoryPointListBasics<T> trajectoryPoints) {
        this.clear(trajectoryPoints.getReferenceFrame());
        this.set(trajectoryPoints);
    }

    @Override
    default public void set(FrameTrajectoryPointListBasics<T> trajectoryPoints) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)trajectoryPoints);
        TrajectoryPointListBasics.super.set(trajectoryPoints);
    }

    default public void applyTransform(Transform transform) {
        for (int i = 0; i < this.getNumberOfTrajectoryPoints(); ++i) {
            ((Transformable)this.getTrajectoryPoint(i)).applyTransform(transform);
        }
    }

    default public void applyInverseTransform(Transform transform) {
        for (int i = 0; i < this.getNumberOfTrajectoryPoints(); ++i) {
            ((Transformable)this.getTrajectoryPoint(i)).applyInverseTransform(transform);
        }
    }
}

