/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces;

import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameQuaternionBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameFactories;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.robotics.math.trajectories.trajectorypoints.SO3TrajectoryPoint;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.FrameSO3TrajectoryPointReadOnly;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.SO3TrajectoryPointBasics;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.SO3TrajectoryPointReadOnly;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.FixedFrameSO3WaypointBasics;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.FrameSO3WaypointReadOnly;

public interface FixedFrameSO3TrajectoryPointBasics
extends FrameSO3TrajectoryPointReadOnly,
SO3TrajectoryPointBasics,
FixedFrameSO3WaypointBasics {
    default public void set(double time, FrameOrientation3DReadOnly orientation, FrameVector3DReadOnly angularVelocity) {
        this.setTime(time);
        this.set(orientation, angularVelocity);
    }

    default public void set(double time, FrameSO3WaypointReadOnly waypoint) {
        this.setTime(time);
        this.set(waypoint);
    }

    default public void set(FrameSO3TrajectoryPointReadOnly other) {
        this.set(other.getTime(), other);
    }

    default public void set(ReferenceFrame referenceFrame, SO3TrajectoryPointReadOnly other) {
        this.checkReferenceFrameMatch(referenceFrame);
        this.set(other);
    }

    public static FixedFrameSO3TrajectoryPointBasics newFixedFrameSO3TrajectoryPointBasics(ReferenceFrameHolder referenceFrameHolder) {
        return FixedFrameSO3TrajectoryPointBasics.newLinkedFixedFrameSO3TrajectoryPointBasics(referenceFrameHolder, new SO3TrajectoryPoint());
    }

    public static FixedFrameSO3TrajectoryPointBasics newLinkedFixedFrameSO3TrajectoryPointBasics(final ReferenceFrameHolder referenceFrameHolder, final SO3TrajectoryPointBasics originalTrajectoryPoint) {
        return new FixedFrameSO3TrajectoryPointBasics(){
            private final FixedFrameQuaternionBasics orientation;
            private final FixedFrameVector3DBasics angularVelocity;
            {
                this.orientation = EuclidFrameFactories.newLinkedFixedFrameQuaternionBasics((ReferenceFrameHolder)referenceFrameHolder, (QuaternionBasics)originalTrajectoryPoint.getOrientation());
                this.angularVelocity = EuclidFrameFactories.newLinkedFixedFrameVector3DBasics((ReferenceFrameHolder)referenceFrameHolder, (Vector3DBasics)originalTrajectoryPoint.getAngularVelocity());
            }

            public ReferenceFrame getReferenceFrame() {
                return referenceFrameHolder.getReferenceFrame();
            }

            @Override
            public FixedFrameQuaternionBasics getOrientation() {
                return this.orientation;
            }

            @Override
            public FixedFrameVector3DBasics getAngularVelocity() {
                return this.angularVelocity;
            }

            @Override
            public void setTime(double time) {
                originalTrajectoryPoint.setTime(time);
            }

            @Override
            public double getTime() {
                return originalTrajectoryPoint.getTime();
            }

            public int hashCode() {
                return EuclidHashCodeTools.toIntHashCode((Object)this.getTime(), (Object)this.getOrientation(), (Object)this.getAngularVelocity());
            }

            public boolean equals(Object object) {
                if (object == this) {
                    return true;
                }
                if (object instanceof FrameSO3TrajectoryPointReadOnly) {
                    return this.equals((FrameSO3TrajectoryPointReadOnly)object);
                }
                return false;
            }

            public String toString() {
                return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
            }
        };
    }
}

