/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces;

import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.robotics.math.trajectories.trajectorypoints.SE3TrajectoryPoint;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.FixedFrameEuclideanTrajectoryPointBasics;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.FixedFrameSO3TrajectoryPointBasics;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.FrameSE3TrajectoryPointReadOnly;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.SE3TrajectoryPointBasics;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.SE3TrajectoryPointReadOnly;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.FixedFrameEuclideanWaypointBasics;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.FixedFrameSE3WaypointBasics;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.FixedFrameSO3WaypointBasics;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.FrameEuclideanWaypointReadOnly;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.FrameSE3WaypointReadOnly;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.FrameSO3WaypointReadOnly;

public interface FixedFrameSE3TrajectoryPointBasics
extends FrameSE3TrajectoryPointReadOnly,
SE3TrajectoryPointBasics,
FixedFrameSE3WaypointBasics,
FixedFrameEuclideanTrajectoryPointBasics,
FixedFrameSO3TrajectoryPointBasics {
    default public void set(double time, FramePoint3DReadOnly position, FrameOrientation3DReadOnly orientation, FrameVector3DReadOnly linearVelocity, FrameVector3DReadOnly angularVelocity) {
        this.setTime(time);
        this.set(position, orientation, linearVelocity, angularVelocity);
    }

    default public void set(double time, FrameSE3WaypointReadOnly waypoint) {
        this.setTime(time);
        this.set(waypoint);
    }

    default public void set(double time, FrameEuclideanWaypointReadOnly euclideanWaypoint, FrameSO3WaypointReadOnly so3Waypoint) {
        this.setTime(time);
        this.set(euclideanWaypoint);
        this.set(so3Waypoint);
    }

    default public void set(FrameSE3TrajectoryPointReadOnly other) {
        this.set(other.getReferenceFrame(), other);
    }

    default public void set(ReferenceFrame referenceFrame, SE3TrajectoryPointReadOnly other) {
        this.checkReferenceFrameMatch(referenceFrame);
        this.set(other);
    }

    public static FixedFrameSE3TrajectoryPointBasics newFixedFrameSE3TrajectoryPointBasics(ReferenceFrameHolder referenceFrameHolder) {
        return FixedFrameSE3TrajectoryPointBasics.newLinkedFixedFrameSE3TrajectoryPointBasics(referenceFrameHolder, new SE3TrajectoryPoint());
    }

    public static FixedFrameSE3TrajectoryPointBasics newLinkedFixedFrameSE3TrajectoryPointBasics(final ReferenceFrameHolder referenceFrameHolder, final SE3TrajectoryPointBasics originalTrajectoryPoint) {
        return new FixedFrameSE3TrajectoryPointBasics(){
            private final FixedFrameEuclideanWaypointBasics euclideanWaypoint = FixedFrameEuclideanWaypointBasics.newFixedFrameEuclideanWaypointBasics((ReferenceFrameHolder)this);
            private final FixedFrameSO3WaypointBasics so3Waypoint = FixedFrameSO3WaypointBasics.newFixedFrameSO3WaypointBasics((ReferenceFrameHolder)this);

            public ReferenceFrame getReferenceFrame() {
                return referenceFrameHolder.getReferenceFrame();
            }

            @Override
            public FixedFrameEuclideanWaypointBasics getEuclideanWaypoint() {
                return this.euclideanWaypoint;
            }

            @Override
            public FixedFrameSO3WaypointBasics getSO3Waypoint() {
                return this.so3Waypoint;
            }

            @Override
            public void setTime(double time) {
                originalTrajectoryPoint.setTime(time);
            }

            @Override
            public double getTime() {
                return originalTrajectoryPoint.getTime();
            }

            public int hashCode() {
                return EuclidHashCodeTools.toIntHashCode((Object)this.getTime(), (Object)this.getEuclideanWaypoint(), (Object)this.getSO3Waypoint());
            }

            public boolean equals(Object object) {
                if (object == this) {
                    return true;
                }
                if (object instanceof FrameSE3TrajectoryPointReadOnly) {
                    return this.equals((FrameSE3TrajectoryPointReadOnly)object);
                }
                return false;
            }

            public String toString() {
                return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
            }
        };
    }
}

