/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces;

import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameFactories;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.robotics.math.trajectories.trajectorypoints.EuclideanTrajectoryPoint;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.EuclideanTrajectoryPointBasics;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.EuclideanTrajectoryPointReadOnly;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.FrameEuclideanTrajectoryPointReadOnly;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.FixedFrameEuclideanWaypointBasics;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.FrameEuclideanWaypointReadOnly;

public interface FixedFrameEuclideanTrajectoryPointBasics
extends FrameEuclideanTrajectoryPointReadOnly,
EuclideanTrajectoryPointBasics,
FixedFrameEuclideanWaypointBasics {
    default public void set(double time, FramePoint3DReadOnly position, FrameVector3DReadOnly linearVelocity) {
        this.setTime(time);
        this.set(position, linearVelocity);
    }

    default public void set(double time, FrameEuclideanWaypointReadOnly waypoint) {
        this.setTime(time);
        this.set(waypoint);
    }

    default public void set(FrameEuclideanTrajectoryPointReadOnly other) {
        this.set(other.getReferenceFrame(), other);
    }

    default public void set(ReferenceFrame referenceFrame, EuclideanTrajectoryPointReadOnly other) {
        this.checkReferenceFrameMatch(referenceFrame);
        this.set(other);
    }

    public static FixedFrameEuclideanTrajectoryPointBasics newFixedFrameEuclideanTrajectoryPointBasics(ReferenceFrameHolder referenceFrameHolder) {
        return FixedFrameEuclideanTrajectoryPointBasics.newLinkedFixedFrameEuclideanTrajectoryPointBasics(referenceFrameHolder, new EuclideanTrajectoryPoint());
    }

    public static FixedFrameEuclideanTrajectoryPointBasics newLinkedFixedFrameEuclideanTrajectoryPointBasics(final ReferenceFrameHolder referenceFrameHolder, final EuclideanTrajectoryPointBasics originalTrajectoryPoint) {
        return new FixedFrameEuclideanTrajectoryPointBasics(){
            private final FixedFramePoint3DBasics position;
            private final FixedFrameVector3DBasics linearVelocity;
            {
                this.position = EuclidFrameFactories.newLinkedFixedFramePoint3DBasics((ReferenceFrameHolder)referenceFrameHolder, (Point3DBasics)originalTrajectoryPoint.getPosition());
                this.linearVelocity = EuclidFrameFactories.newLinkedFixedFrameVector3DBasics((ReferenceFrameHolder)referenceFrameHolder, (Vector3DBasics)originalTrajectoryPoint.getLinearVelocity());
            }

            public ReferenceFrame getReferenceFrame() {
                return referenceFrameHolder.getReferenceFrame();
            }

            @Override
            public FixedFramePoint3DBasics getPosition() {
                return this.position;
            }

            @Override
            public FixedFrameVector3DBasics getLinearVelocity() {
                return this.linearVelocity;
            }

            @Override
            public void setTime(double time) {
                originalTrajectoryPoint.setTime(time);
            }

            @Override
            public double getTime() {
                return originalTrajectoryPoint.getTime();
            }

            public int hashCode() {
                return EuclidHashCodeTools.toIntHashCode((Object)this.getTime(), (Object)this.getPosition(), (Object)this.getLinearVelocity());
            }

            public boolean equals(Object object) {
                if (object == this) {
                    return true;
                }
                if (object instanceof FrameEuclideanTrajectoryPointReadOnly) {
                    return this.equals((FrameEuclideanTrajectoryPointReadOnly)object);
                }
                return false;
            }

            public String toString() {
                return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
            }
        };
    }
}

