/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces;

import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.TrajectoryPointReadOnly;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.EuclideanWaypointReadOnly;

public interface EuclideanTrajectoryPointReadOnly
extends TrajectoryPointReadOnly,
EuclideanWaypointReadOnly {
    @Override
    default public boolean containsNaN() {
        return this.isTimeNaN() || EuclideanWaypointReadOnly.super.containsNaN();
    }

    @Override
    default public boolean equals(EuclidGeometry geometry) {
        if (geometry == this) {
            return true;
        }
        if (geometry == null) {
            return false;
        }
        if (!(geometry instanceof EuclideanTrajectoryPointReadOnly)) {
            return false;
        }
        EuclideanTrajectoryPointReadOnly other = (EuclideanTrajectoryPointReadOnly)geometry;
        if (!EuclidCoreTools.equals((double)this.getTime(), (double)other.getTime())) {
            return false;
        }
        if (!this.getPosition().equals((EuclidGeometry)other.getPosition())) {
            return false;
        }
        return this.getLinearVelocity().equals((EuclidGeometry)other.getLinearVelocity());
    }

    @Override
    default public boolean epsilonEquals(EuclidGeometry geometry, double epsilon) {
        if (geometry == this) {
            return true;
        }
        if (geometry == null) {
            return false;
        }
        if (!(geometry instanceof EuclideanTrajectoryPointReadOnly)) {
            return false;
        }
        EuclideanTrajectoryPointReadOnly other = (EuclideanTrajectoryPointReadOnly)geometry;
        if (!EuclidCoreTools.epsilonEquals((double)this.getTime(), (double)other.getTime(), (double)epsilon)) {
            return false;
        }
        if (!this.getPosition().epsilonEquals((EuclidGeometry)other.getPosition(), epsilon)) {
            return false;
        }
        return this.getLinearVelocity().epsilonEquals((EuclidGeometry)other.getLinearVelocity(), epsilon);
    }

    @Override
    default public boolean geometricallyEquals(EuclidGeometry geometry, double epsilon) {
        if (geometry == this) {
            return true;
        }
        if (geometry == null) {
            return false;
        }
        if (!(geometry instanceof EuclideanWaypointReadOnly)) {
            return false;
        }
        EuclideanTrajectoryPointReadOnly other = (EuclideanTrajectoryPointReadOnly)geometry;
        if (!EuclidCoreTools.epsilonEquals((double)this.getTime(), (double)other.getTime(), (double)epsilon)) {
            return false;
        }
        if (!this.getPosition().geometricallyEquals((EuclidGeometry)other.getPosition(), epsilon)) {
            return false;
        }
        return this.getLinearVelocity().geometricallyEquals((EuclidGeometry)other.getLinearVelocity(), epsilon);
    }

    @Override
    default public String toString(String format) {
        return String.format("Euclidean trajectory point: [time=%s, position=%s, linear velocity=%s]", EuclidCoreIOTools.getStringOf(null, (String)format, (double[])new double[]{this.getTime()}), EuclidCoreIOTools.getTuple3DString((String)format, (Tuple3DReadOnly)this.getPosition()), EuclidCoreIOTools.getTuple3DString((String)format, (Tuple3DReadOnly)this.getLinearVelocity()));
    }
}

