/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.trajectorypoints;

import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.SE3TrajectoryPointBasics;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.SE3TrajectoryPointReadOnly;
import us.ihmc.robotics.math.trajectories.waypoints.YoSE3Waypoint;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.EuclideanWaypointBasics;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.SO3WaypointBasics;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.tools.YoGeometryNameTools;
import us.ihmc.yoVariables.variable.YoDouble;

public class YoSE3TrajectoryPoint
implements SE3TrajectoryPointBasics {
    private final YoSE3Waypoint se3Waypoint;
    private final YoDouble time;
    private final String namePrefix;
    private final String nameSuffix;

    public YoSE3TrajectoryPoint(String namePrefix, String nameSuffix, YoRegistry registry) {
        this.se3Waypoint = new YoSE3Waypoint(namePrefix, nameSuffix, registry);
        this.time = new YoDouble(YoGeometryNameTools.assembleName((String[])new String[]{namePrefix, "time", nameSuffix}), registry);
        this.namePrefix = namePrefix;
        this.nameSuffix = nameSuffix;
    }

    @Override
    public EuclideanWaypointBasics getEuclideanWaypoint() {
        return this.se3Waypoint.getEuclideanWaypoint();
    }

    @Override
    public SO3WaypointBasics getSO3Waypoint() {
        return this.se3Waypoint.getSO3Waypoint();
    }

    @Override
    public void setTime(double time) {
        this.time.set(time);
    }

    @Override
    public double getTime() {
        return this.time.getValue();
    }

    public String getNamePrefix() {
        return this.namePrefix;
    }

    public String getNameSuffix() {
        return this.nameSuffix;
    }

    public int hashCode() {
        return EuclidHashCodeTools.toIntHashCode((Object)this.getTime(), (Object)this.getOrientation(), (Object)this.getAngularVelocity());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof SE3TrajectoryPointReadOnly) {
            return this.equals((SE3TrajectoryPointReadOnly)object);
        }
        return false;
    }

    public String toString() {
        return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
    }
}

