/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.trajectorypoints;

import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint3DBasics;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.FrameSE3TrajectoryPointBasics;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.FrameSE3TrajectoryPointReadOnly;
import us.ihmc.robotics.math.trajectories.waypoints.YoFrameSE3Waypoint;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.FixedFrameEuclideanWaypointBasics;
import us.ihmc.robotics.math.trajectories.waypoints.interfaces.FixedFrameSO3WaypointBasics;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.tools.YoGeometryNameTools;
import us.ihmc.yoVariables.variable.YoDouble;

public class YoFrameSE3TrajectoryPoint
implements FrameSE3TrajectoryPointBasics {
    private final YoFrameSE3Waypoint se3Waypoint;
    private final YoDouble time;
    private final String namePrefix;
    private final String nameSuffix;

    public YoFrameSE3TrajectoryPoint(String namePrefix, String nameSuffix, YoRegistry registry) {
        this.se3Waypoint = new YoFrameSE3Waypoint(namePrefix, nameSuffix, registry);
        this.time = new YoDouble(YoGeometryNameTools.assembleName((String[])new String[]{namePrefix, "time", nameSuffix}), registry);
        this.namePrefix = namePrefix;
        this.nameSuffix = nameSuffix;
    }

    public YoFrameSE3TrajectoryPoint(String namePrefix, String nameSuffix, YoRegistry registry, ReferenceFrame referenceFrame) {
        this.se3Waypoint = new YoFrameSE3Waypoint(namePrefix, nameSuffix, registry);
        this.time = new YoDouble(YoGeometryNameTools.assembleName((String[])new String[]{namePrefix, "time", nameSuffix}), registry);
        this.namePrefix = namePrefix;
        this.nameSuffix = nameSuffix;
        this.setToZero(referenceFrame);
    }

    @Override
    public FixedFrameEuclideanWaypointBasics getEuclideanWaypoint() {
        return this.se3Waypoint.getEuclideanWaypoint();
    }

    @Override
    public FixedFrameSO3WaypointBasics getSO3Waypoint() {
        return this.se3Waypoint.getSO3Waypoint();
    }

    @Override
    public FixedFramePoint3DBasics getPosition() {
        return this.se3Waypoint.getPosition();
    }

    public void setReferenceFrame(ReferenceFrame referenceFrame) {
        this.se3Waypoint.setReferenceFrame(referenceFrame);
    }

    public ReferenceFrame getReferenceFrame() {
        return this.se3Waypoint.getReferenceFrame();
    }

    @Override
    public void setTime(double time) {
        this.time.set(time);
    }

    @Override
    public double getTime() {
        return this.time.getValue();
    }

    public String getNamePrefix() {
        return this.namePrefix;
    }

    public String getNameSuffix() {
        return this.nameSuffix;
    }

    public int hashCode() {
        return EuclidHashCodeTools.toIntHashCode((Object)this.getTime(), (Object)this.getEuclideanWaypoint(), (Object)this.getSO3Waypoint());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof FrameSE3TrajectoryPointReadOnly) {
            return this.equals((FrameSE3TrajectoryPointReadOnly)object);
        }
        return false;
    }

    public String toString() {
        return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
    }
}

