/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.trajectorypoints;

import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.FrameEuclideanTrajectoryPointBasics;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.FrameEuclideanTrajectoryPointReadOnly;
import us.ihmc.robotics.math.trajectories.waypoints.YoFrameEuclideanWaypoint;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.tools.YoGeometryNameTools;
import us.ihmc.yoVariables.variable.YoDouble;

public class YoFrameEuclideanTrajectoryPoint
implements FrameEuclideanTrajectoryPointBasics {
    private final YoFrameEuclideanWaypoint euclideanWaypoint;
    private final YoDouble time;
    private final String namePrefix;
    private final String nameSuffix;

    public YoFrameEuclideanTrajectoryPoint(String namePrefix, String nameSuffix, YoRegistry registry) {
        this.euclideanWaypoint = new YoFrameEuclideanWaypoint(namePrefix, nameSuffix, registry);
        this.time = new YoDouble(YoGeometryNameTools.assembleName((String[])new String[]{namePrefix, "time", nameSuffix}), registry);
        this.namePrefix = namePrefix;
        this.nameSuffix = nameSuffix;
    }

    public YoFrameEuclideanTrajectoryPoint(String namePrefix, String nameSuffix, YoRegistry registry, ReferenceFrame referenceFrame) {
        this.euclideanWaypoint = new YoFrameEuclideanWaypoint(namePrefix, nameSuffix, registry);
        this.time = new YoDouble(YoGeometryNameTools.assembleName((String[])new String[]{namePrefix, "time", nameSuffix}), registry);
        this.namePrefix = namePrefix;
        this.nameSuffix = nameSuffix;
        this.setToZero(referenceFrame);
    }

    public YoDouble getYoX() {
        return this.euclideanWaypoint.getYoX();
    }

    public YoDouble getYoY() {
        return this.euclideanWaypoint.getYoY();
    }

    public YoDouble getYoZ() {
        return this.euclideanWaypoint.getYoZ();
    }

    @Override
    public FixedFramePoint3DBasics getPosition() {
        return this.euclideanWaypoint.getPosition();
    }

    @Override
    public FixedFrameVector3DBasics getLinearVelocity() {
        return this.euclideanWaypoint.getLinearVelocity();
    }

    public void setReferenceFrame(ReferenceFrame referenceFrame) {
        this.euclideanWaypoint.setReferenceFrame(referenceFrame);
    }

    public ReferenceFrame getReferenceFrame() {
        return this.euclideanWaypoint.getReferenceFrame();
    }

    @Override
    public void setTime(double time) {
        this.time.set(time);
    }

    @Override
    public double getTime() {
        return this.time.getValue();
    }

    public String getNamePrefix() {
        return this.namePrefix;
    }

    public String getNameSuffix() {
        return this.nameSuffix;
    }

    public int hashCode() {
        return EuclidHashCodeTools.toIntHashCode((Object)this.getTime(), (Object)this.getPosition(), (Object)this.getLinearVelocity());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof FrameEuclideanTrajectoryPointReadOnly) {
            return this.equals((FrameEuclideanTrajectoryPointReadOnly)object);
        }
        return false;
    }

    public String toString() {
        return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
    }
}

