/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.trajectorypoints;

import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameQuaternionBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.FrameSO3TrajectoryPointBasics;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.FrameSO3TrajectoryPointReadOnly;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.SO3TrajectoryPointReadOnly;
import us.ihmc.robotics.math.trajectories.waypoints.FrameSO3Waypoint;

public class FrameSO3TrajectoryPoint
implements FrameSO3TrajectoryPointBasics {
    private final FrameSO3Waypoint so3Waypoint = new FrameSO3Waypoint();
    private double time;

    public FrameSO3TrajectoryPoint() {
    }

    public FrameSO3TrajectoryPoint(ReferenceFrame referenceFrame) {
        this.setToZero(referenceFrame);
    }

    public FrameSO3TrajectoryPoint(double time, FrameOrientation3DReadOnly orientation, FrameVector3DReadOnly angularVelocity) {
        this.setIncludingFrame(time, orientation, angularVelocity);
    }

    public FrameSO3TrajectoryPoint(FrameSO3TrajectoryPointReadOnly other) {
        this.setIncludingFrame(other);
    }

    public FrameSO3TrajectoryPoint(ReferenceFrame referenceFrame, SO3TrajectoryPointReadOnly other) {
        this.setIncludingFrame(referenceFrame, other);
    }

    @Override
    public FixedFrameQuaternionBasics getOrientation() {
        return this.so3Waypoint.getOrientation();
    }

    @Override
    public FixedFrameVector3DBasics getAngularVelocity() {
        return this.so3Waypoint.getAngularVelocity();
    }

    public void setReferenceFrame(ReferenceFrame referenceFrame) {
        this.so3Waypoint.setReferenceFrame(referenceFrame);
    }

    public ReferenceFrame getReferenceFrame() {
        return this.so3Waypoint.getReferenceFrame();
    }

    @Override
    public void setTime(double time) {
        this.time = time;
    }

    @Override
    public double getTime() {
        return this.time;
    }

    public int hashCode() {
        return EuclidHashCodeTools.toIntHashCode((Object)this.getTime(), (Object)this.getOrientation(), (Object)this.getAngularVelocity());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof FrameSO3TrajectoryPointReadOnly) {
            return this.equals((FrameSO3TrajectoryPointReadOnly)object);
        }
        return false;
    }

    public String toString() {
        return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
    }
}

