/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.trajectorypoints;

import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.EuclideanTrajectoryPointReadOnly;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.FrameEuclideanTrajectoryPointBasics;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.FrameEuclideanTrajectoryPointReadOnly;
import us.ihmc.robotics.math.trajectories.waypoints.FrameEuclideanWaypoint;

public class FrameEuclideanTrajectoryPoint
implements FrameEuclideanTrajectoryPointBasics {
    private final FrameEuclideanWaypoint euclideanWaypoint = new FrameEuclideanWaypoint();
    private double time;

    public FrameEuclideanTrajectoryPoint() {
    }

    public FrameEuclideanTrajectoryPoint(ReferenceFrame referenceFrame) {
        this.setToZero(referenceFrame);
    }

    public FrameEuclideanTrajectoryPoint(double time, FramePoint3DReadOnly position, FrameVector3DReadOnly linearVelocity) {
        this.setIncludingFrame(time, position, linearVelocity);
    }

    public FrameEuclideanTrajectoryPoint(FrameEuclideanTrajectoryPointReadOnly other) {
        this.setIncludingFrame(other);
    }

    public FrameEuclideanTrajectoryPoint(ReferenceFrame referenceFrame, EuclideanTrajectoryPointReadOnly other) {
        this.setIncludingFrame(referenceFrame, other);
    }

    @Override
    public FixedFramePoint3DBasics getPosition() {
        return this.euclideanWaypoint.getPosition();
    }

    @Override
    public FixedFrameVector3DBasics getLinearVelocity() {
        return this.euclideanWaypoint.getLinearVelocity();
    }

    public void setReferenceFrame(ReferenceFrame referenceFrame) {
        this.euclideanWaypoint.setReferenceFrame(referenceFrame);
    }

    public ReferenceFrame getReferenceFrame() {
        return this.euclideanWaypoint.getReferenceFrame();
    }

    @Override
    public void setTime(double time) {
        this.time = time;
    }

    @Override
    public double getTime() {
        return this.time;
    }

    public int hashCode() {
        return EuclidHashCodeTools.toIntHashCode((Object)this.getTime(), (Object)this.getPosition(), (Object)this.getLinearVelocity());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof FrameEuclideanTrajectoryPointReadOnly) {
            return this.equals((FrameEuclideanTrajectoryPointReadOnly)object);
        }
        return false;
    }

    public String toString() {
        return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
    }
}

