/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.generators;

import java.util.ArrayList;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.robotics.math.trajectories.interfaces.DoubleTrajectoryGenerator;
import us.ihmc.robotics.math.trajectories.trajectorypoints.YoOneDoFTrajectoryPoint;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.OneDoFTrajectoryPointBasics;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.TrajectoryPointListBasics;
import us.ihmc.robotics.math.trajectories.yoVariables.YoPolynomial;
import us.ihmc.robotics.trajectories.providers.SettableDoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;

public class MultipleWaypointsMinimumJerkTrajectoryGenerator
implements DoubleTrajectoryGenerator {
    public static final int defaultMaximumNumberOfWaypoints = 30;
    private final int maximumNumberOfWaypoints;
    private final String namePrefix;
    private final YoRegistry registry;
    private final YoDouble currentTrajectoryTime;
    private final YoInteger numberOfWaypoints;
    private final YoInteger currentWaypointIndex;
    private final ArrayList<YoOneDoFTrajectoryPoint> waypoints;
    private final SettableDoubleProvider initialPositionProvider = new SettableDoubleProvider();
    private final SettableDoubleProvider initialVelocityProvider = new SettableDoubleProvider();
    private final SettableDoubleProvider initialAccelerationProvider = new SettableDoubleProvider();
    private final SettableDoubleProvider finalPositionProvider = new SettableDoubleProvider();
    private final SettableDoubleProvider finalVelocityProvider = new SettableDoubleProvider();
    private final SettableDoubleProvider finalAccelerationProvider = new SettableDoubleProvider();
    private final SettableDoubleProvider trajectoryTimeProvider = new SettableDoubleProvider();
    private final YoPolynomial subTrajectory;

    public MultipleWaypointsMinimumJerkTrajectoryGenerator(String namePrefix, YoRegistry parentRegistry) {
        this(namePrefix, 30, parentRegistry);
    }

    public MultipleWaypointsMinimumJerkTrajectoryGenerator(String namePrefix, int maximumNumberOfWaypoints, YoRegistry parentRegistry) {
        this.namePrefix = namePrefix;
        this.maximumNumberOfWaypoints = maximumNumberOfWaypoints;
        this.registry = new YoRegistry(namePrefix + this.getClass().getSimpleName());
        parentRegistry.addChild(this.registry);
        this.numberOfWaypoints = new YoInteger(namePrefix + "NumberOfWaypoints", this.registry);
        this.numberOfWaypoints.set(0);
        this.currentTrajectoryTime = new YoDouble(namePrefix + "TrajectoryTime", this.registry);
        this.currentWaypointIndex = new YoInteger(namePrefix + "CurrentWaypointIndex", this.registry);
        this.subTrajectory = new YoPolynomial(namePrefix + "SubTrajectory", 6, this.registry);
        this.waypoints = new ArrayList(maximumNumberOfWaypoints);
        for (int i = 0; i < maximumNumberOfWaypoints; ++i) {
            YoOneDoFTrajectoryPoint waypoint = new YoOneDoFTrajectoryPoint(namePrefix, "AtWaypoint" + i, this.registry);
            this.waypoints.add(waypoint);
        }
        this.clear();
    }

    public void clear() {
        this.numberOfWaypoints.set(0);
        this.currentWaypointIndex.set(0);
        for (int i = 0; i < this.maximumNumberOfWaypoints; ++i) {
            this.waypoints.get(i).setToNaN();
        }
    }

    public void appendWaypoint(double timeAtWaypoint, double position, double velocity) {
        this.checkNumberOfWaypoints(this.numberOfWaypoints.getIntegerValue() + 1);
        this.appendWaypointUnsafe(timeAtWaypoint, position, velocity);
    }

    private void appendWaypointUnsafe(double timeAtWaypoint, double position, double velocity) {
        this.waypoints.get(this.numberOfWaypoints.getIntegerValue()).set(timeAtWaypoint, position, velocity);
        this.numberOfWaypoints.increment();
    }

    public void appendWaypoints(double[] timeAtWaypoints, double[] positions, double[] velocities) {
        if (timeAtWaypoints.length != positions.length || positions.length != velocities.length) {
            throw new RuntimeException("Arguments are inconsistent.");
        }
        this.checkNumberOfWaypoints(this.numberOfWaypoints.getIntegerValue() + timeAtWaypoints.length);
        for (int i = 0; i < timeAtWaypoints.length; ++i) {
            this.appendWaypointUnsafe(timeAtWaypoints[i], positions[i], velocities[i]);
        }
    }

    public void appendWaypoint(OneDoFTrajectoryPointBasics waypoint1D) {
        this.appendWaypoint(waypoint1D.getTime(), waypoint1D.getPosition(), waypoint1D.getVelocity());
    }

    public void appendWaypoints(OneDoFTrajectoryPointBasics[] waypoints1D) {
        this.checkNumberOfWaypoints(this.numberOfWaypoints.getIntegerValue() + waypoints1D.length);
        for (int i = 0; i < waypoints1D.length; ++i) {
            this.appendWaypointUnsafe(waypoints1D[i].getTime(), waypoints1D[i].getPosition(), waypoints1D[i].getVelocity());
        }
    }

    public void appendWaypoints(RecyclingArrayList<? extends OneDoFTrajectoryPointBasics> waypoints1D) {
        this.checkNumberOfWaypoints(this.numberOfWaypoints.getIntegerValue() + waypoints1D.size());
        for (int i = 0; i < waypoints1D.size(); ++i) {
            this.appendWaypointUnsafe(((OneDoFTrajectoryPointBasics)waypoints1D.get(i)).getTime(), ((OneDoFTrajectoryPointBasics)waypoints1D.get(i)).getPosition(), ((OneDoFTrajectoryPointBasics)waypoints1D.get(i)).getVelocity());
        }
    }

    public <W extends OneDoFTrajectoryPointBasics> void appendWaypoints(TrajectoryPointListBasics<W> trajectoryWaypoint1DData) {
        for (int i = 0; i < trajectoryWaypoint1DData.getNumberOfTrajectoryPoints(); ++i) {
            this.appendWaypoint((OneDoFTrajectoryPointBasics)trajectoryWaypoint1DData.getTrajectoryPoint(i));
        }
    }

    private void checkNumberOfWaypoints(int length) {
        if (length > this.maximumNumberOfWaypoints) {
            throw new RuntimeException("Cannot exceed the maximum number of waypoints. Number of waypoints provided: " + length);
        }
    }

    @Override
    public void initialize() {
        if (this.isEmpty()) {
            throw new RuntimeException("Trajectory has no waypoints.");
        }
        this.currentWaypointIndex.set(0);
        if (this.numberOfWaypoints.getIntegerValue() == 1) {
            YoOneDoFTrajectoryPoint firstWaypoint = this.waypoints.get(0);
            this.finalPositionProvider.setValue(firstWaypoint.getPosition());
            this.finalVelocityProvider.setValue(firstWaypoint.getVelocity());
            this.trajectoryTimeProvider.setValue(0.0);
            this.subTrajectory.setLinear(this.trajectoryTimeProvider.getValue(), this.finalPositionProvider.getValue(), this.finalVelocityProvider.getValue());
        } else {
            this.initializeSubTrajectory(0);
        }
    }

    private void initializeSubTrajectory(int waypointIndex) {
        this.initialPositionProvider.setValue(this.waypoints.get(waypointIndex).getPosition());
        this.initialVelocityProvider.setValue(this.waypoints.get(waypointIndex).getVelocity());
        this.finalPositionProvider.setValue(this.waypoints.get(waypointIndex + 1).getPosition());
        this.finalVelocityProvider.setValue(this.waypoints.get(waypointIndex + 1).getVelocity());
        if (waypointIndex > 0) {
            this.initialAccelerationProvider.setValue(this.subTrajectory.getAcceleration());
        }
        this.finalAccelerationProvider.setValue(0.0);
        double subTrajectoryTime = this.waypoints.get(waypointIndex + 1).getTime() - this.waypoints.get(waypointIndex).getTime();
        this.trajectoryTimeProvider.setValue(subTrajectoryTime);
        this.subTrajectory.setQuinticWithZeroTerminalAcceleration(0.0, this.trajectoryTimeProvider.getValue(), this.initialPositionProvider.getValue(), this.initialVelocityProvider.getValue(), this.finalPositionProvider.getValue(), this.finalVelocityProvider.getValue());
    }

    @Override
    public void compute(double time) {
        this.currentTrajectoryTime.set(time);
        if (this.currentWaypointIndex.getIntegerValue() < this.numberOfWaypoints.getIntegerValue() - 2 && time >= this.waypoints.get(this.currentWaypointIndex.getIntegerValue() + 1).getTime()) {
            this.currentWaypointIndex.increment();
            this.initializeSubTrajectory(this.currentWaypointIndex.getIntegerValue());
        }
        double subTrajectoryTime = time < this.waypoints.get(this.numberOfWaypoints.getIntegerValue() - 1).getTime() ? time - this.waypoints.get(this.currentWaypointIndex.getIntegerValue()).getTime() : this.waypoints.get(this.numberOfWaypoints.getIntegerValue() - 1).getTime() - this.waypoints.get(this.numberOfWaypoints.getIntegerValue() - 2).getTime();
        this.subTrajectory.compute(subTrajectoryTime);
    }

    @Override
    public boolean isDone() {
        boolean isLastWaypoint;
        if (this.isEmpty()) {
            return true;
        }
        boolean bl = isLastWaypoint = this.currentWaypointIndex.getIntegerValue() >= this.numberOfWaypoints.getIntegerValue() - 2;
        if (!isLastWaypoint) {
            return false;
        }
        boolean subTrajectoryIsDone = this.subTrajectory.isDone();
        return subTrajectoryIsDone;
    }

    public boolean isEmpty() {
        return this.numberOfWaypoints.getIntegerValue() == 0;
    }

    public double getValue() {
        return this.subTrajectory.getValue();
    }

    @Override
    public double getVelocity() {
        return this.subTrajectory.getVelocity();
    }

    @Override
    public double getAcceleration() {
        return this.subTrajectory.getAcceleration();
    }

    public int getCurrentNumberOfWaypoints() {
        return this.numberOfWaypoints.getIntegerValue();
    }

    public int getMaximumNumberOfWaypoints() {
        return this.maximumNumberOfWaypoints;
    }

    public double getLastWaypointTime() {
        return this.waypoints.get(this.numberOfWaypoints.getIntegerValue() - 1).getTime();
    }

    public String toString() {
        if (this.isEmpty()) {
            return this.namePrefix + ": Has no waypoints.";
        }
        return this.namePrefix + ": number of waypoints = " + this.numberOfWaypoints.getIntegerValue() + ", current waypoint index = " + this.currentWaypointIndex.getIntegerValue() + "\nFirst waypoint: " + this.waypoints.get(0) + ", last waypoint: " + this.waypoints.get(this.numberOfWaypoints.getIntegerValue() - 1);
    }
}

