/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.generators;

import gnu.trove.TDoubleCollection;
import gnu.trove.list.array.TDoubleArrayList;
import java.util.ArrayList;
import org.apache.commons.math3.util.Precision;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.log.LogTools;
import us.ihmc.robotics.math.trajectories.generators.TrajectoryPointOptimizer;
import us.ihmc.robotics.math.trajectories.trajectorypoints.FrameEuclideanTrajectoryPoint;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.EuclideanTrajectoryPointBasics;
import us.ihmc.robotics.math.trajectories.trajectorypoints.lists.FrameEuclideanTrajectoryPointList;

public class EuclideanTrajectoryPointCalculator {
    private static final int dimension = Axis3D.values.length;
    private static final int maxIterations = 2000;
    private final TrajectoryPointOptimizer trajectoryPointOptimizer = new TrajectoryPointOptimizer(dimension);
    private final FrameEuclideanTrajectoryPointList trajectoryPoints = new FrameEuclideanTrajectoryPointList();
    private final TDoubleArrayList times = new TDoubleArrayList();

    public void clear() {
        this.trajectoryPoints.clear();
        this.times.reset();
    }

    public void appendTrajectoryPoint(EuclideanTrajectoryPointBasics trajectoryPoint) {
        this.trajectoryPoints.addTrajectoryPoint(trajectoryPoint);
    }

    public void appendTrajectoryPoint(Point3DBasics position) {
        FrameEuclideanTrajectoryPoint newTrajectoryPoint = new FrameEuclideanTrajectoryPoint();
        newTrajectoryPoint.setToZero(this.trajectoryPoints.getReferenceFrame());
        newTrajectoryPoint.setTimeToNaN();
        newTrajectoryPoint.getPosition().set((Tuple3DReadOnly)position);
        newTrajectoryPoint.getLinearVelocity().setToNaN();
        this.trajectoryPoints.addTrajectoryPoint(newTrajectoryPoint);
    }

    public void appendTrajectoryPoint(double time, Point3DBasics position) {
        FrameEuclideanTrajectoryPoint newTrajectoryPoint = new FrameEuclideanTrajectoryPoint();
        newTrajectoryPoint.setToZero(this.trajectoryPoints.getReferenceFrame());
        newTrajectoryPoint.setTime(time);
        newTrajectoryPoint.getPosition().set((Tuple3DReadOnly)position);
        newTrajectoryPoint.getLinearVelocity().setToNaN();
        this.trajectoryPoints.addTrajectoryPoint(newTrajectoryPoint);
        this.times.add(time);
    }

    public void appendTrajectoryPoint(double time, Point3DBasics position, Vector3DBasics linearVelocity) {
        FrameEuclideanTrajectoryPoint newTrajectoryPoint = new FrameEuclideanTrajectoryPoint();
        newTrajectoryPoint.setToZero(this.trajectoryPoints.getReferenceFrame());
        newTrajectoryPoint.setTime(time);
        newTrajectoryPoint.getPosition().set((Tuple3DReadOnly)position);
        newTrajectoryPoint.getLinearVelocity().set((Tuple3DReadOnly)linearVelocity);
        this.trajectoryPoints.addTrajectoryPoint(newTrajectoryPoint);
        this.times.add(time);
    }

    public void changeFrame(ReferenceFrame referenceFrame) {
        this.trajectoryPoints.changeFrame(referenceFrame);
    }

    public void compute(double trajectoryTime) {
        int i;
        TDoubleArrayList startPosition = new TDoubleArrayList();
        TDoubleArrayList startVelocity = new TDoubleArrayList();
        TDoubleArrayList finalPosition = new TDoubleArrayList();
        TDoubleArrayList finalVelocity = new TDoubleArrayList();
        FrameEuclideanTrajectoryPoint first = this.trajectoryPoints.getTrajectoryPoint(0);
        FrameEuclideanTrajectoryPoint last = (FrameEuclideanTrajectoryPoint)this.trajectoryPoints.getLastTrajectoryPoint();
        if (first.getLinearVelocity().containsNaN()) {
            first.getLinearVelocity().set(0.0, 0.0, 0.0);
        }
        if (last.getLinearVelocity().containsNaN()) {
            last.getLinearVelocity().set(0.0, 0.0, 0.0);
        }
        for (int i2 = 0; i2 < dimension; ++i2) {
            startPosition.add(first.getPosition().getElement(i2));
            startVelocity.add(first.getLinearVelocity().getElement(i2));
            finalPosition.add(last.getPosition().getElement(i2));
            finalVelocity.add(last.getLinearVelocity().getElement(i2));
        }
        ArrayList<TDoubleArrayList> waypoints = new ArrayList<TDoubleArrayList>();
        for (i = 1; i < this.trajectoryPoints.getNumberOfTrajectoryPoints() - 1; ++i) {
            TDoubleArrayList waypointXYZ = new TDoubleArrayList();
            for (int j = 0; j < dimension; ++j) {
                waypointXYZ.add(this.trajectoryPoints.getTrajectoryPoint(i).getPosition().getElement(j));
            }
            waypoints.add(waypointXYZ);
        }
        this.trajectoryPointOptimizer.setEndPoints(startPosition, startVelocity, finalPosition, finalVelocity);
        this.trajectoryPointOptimizer.setWaypoints(waypoints);
        if (this.times.size() == 0) {
            this.computeIncludingTimes();
        } else {
            this.computeForFixedTime(trajectoryTime);
        }
        this.times.clear();
        this.times.add(0.0);
        for (i = 0; i < waypoints.size(); ++i) {
            this.times.add(this.trajectoryPointOptimizer.getWaypointTime(i) * trajectoryTime);
        }
        this.times.add(trajectoryTime);
        for (i = 0; i < this.trajectoryPoints.getNumberOfTrajectoryPoints(); ++i) {
            this.trajectoryPoints.getTrajectoryPoint(i).setTime(this.times.get(i));
        }
        for (i = 0; i < waypoints.size(); ++i) {
            TDoubleArrayList velocityToPack = new TDoubleArrayList();
            this.trajectoryPointOptimizer.getWaypointVelocity(velocityToPack, i);
            Vector3D waypointVelocity = new Vector3D();
            for (int j = 0; j < velocityToPack.size(); ++j) {
                waypointVelocity.setElement(j, velocityToPack.get(j) / trajectoryTime);
            }
            this.trajectoryPoints.getTrajectoryPoint(i + 1).getLinearVelocity().set((Tuple3DReadOnly)waypointVelocity);
        }
    }

    private void computeForFixedTime(double trajectoryTime) {
        if (this.times.size() != this.trajectoryPoints.getNumberOfTrajectoryPoints()) {
            LogTools.warn((String)"If providing times provide one for each position waypoint!");
            throw new RuntimeException("If providing times provide one for each position waypoint!");
        }
        if (!Precision.equals((double)this.times.get(0), (double)0.0, (double)Double.MIN_VALUE)) {
            LogTools.warn((String)"First time must be zero. Offset your trajectory later!");
            throw new RuntimeException("First time must be zero. Offset your trajectory later!");
        }
        if (!Precision.equals((double)this.times.get(this.times.size() - 1), (double)trajectoryTime, (double)Double.MIN_VALUE)) {
            LogTools.warn((String)"Last waypoint time must match the trajectory time!");
            throw new RuntimeException("Last waypoint time must match the trajectory time!");
        }
        TDoubleArrayList waypointTimes = new TDoubleArrayList((TDoubleCollection)this.times.subList(1, this.times.size() - 1));
        waypointTimes.transformValues(time -> time / trajectoryTime);
        this.trajectoryPointOptimizer.computeForFixedTime(waypointTimes);
    }

    private void computeIncludingTimes() {
        this.trajectoryPointOptimizer.compute(2000);
    }

    public int getNumberOfTrajectoryPoints() {
        return this.trajectoryPoints.getNumberOfTrajectoryPoints();
    }

    public FrameEuclideanTrajectoryPoint getTrajectoryPoint(int i) {
        return this.trajectoryPoints.getTrajectoryPoint(i);
    }

    public FrameEuclideanTrajectoryPointList getTrajectoryPoints() {
        return this.trajectoryPoints;
    }
}

