/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.core;

import java.util.function.DoubleConsumer;
import us.ihmc.commons.MathTools;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.robotics.time.TimeIntervalBasics;
import us.ihmc.robotics.time.TimeIntervalProvider;
import us.ihmc.yoVariables.providers.DoubleProvider;

public class Trajectory3DFactories {
    public static TimeIntervalBasics newLinkedTimeInterval(TimeIntervalProvider xInterval, TimeIntervalProvider yInterval, TimeIntervalProvider zInterval) {
        return Trajectory3DFactories.newLinkedTimeInterval(xInterval.getTimeInterval(), yInterval.getTimeInterval(), zInterval.getTimeInterval());
    }

    public static TimeIntervalBasics newLinkedTimeInterval(final TimeIntervalBasics xInterval, final TimeIntervalBasics yInterval, final TimeIntervalBasics zInterval) {
        return new TimeIntervalBasics(){

            @Override
            public void setStartTime(double startTime) {
                xInterval.setStartTime(startTime);
                yInterval.setStartTime(startTime);
                zInterval.setStartTime(startTime);
            }

            @Override
            public void setEndTime(double endTime) {
                xInterval.setEndTime(endTime);
                yInterval.setEndTime(endTime);
                zInterval.setEndTime(endTime);
            }

            @Override
            public double getStartTime() {
                if (!MathTools.epsilonEquals((double)xInterval.getStartTime(), (double)yInterval.getStartTime(), (double)1.0E-5) || !MathTools.epsilonEquals((double)xInterval.getStartTime(), (double)zInterval.getStartTime(), (double)1.0E-5)) {
                    throw new RuntimeException("Time intervals are wrong.");
                }
                return xInterval.getStartTime();
            }

            @Override
            public double getEndTime() {
                if (!MathTools.epsilonEquals((double)xInterval.getEndTime(), (double)yInterval.getEndTime(), (double)1.0E-5) || !MathTools.epsilonEquals((double)xInterval.getEndTime(), (double)zInterval.getEndTime(), (double)1.0E-5)) {
                    throw new RuntimeException("Time intervals are wrong.");
                }
                return xInterval.getEndTime();
            }

            public boolean equals(Object object) {
                if (object == this) {
                    return true;
                }
                if (object instanceof TimeIntervalBasics) {
                    return this.equals((TimeIntervalBasics)object);
                }
                return false;
            }

            public int hashCode() {
                return EuclidHashCodeTools.toIntHashCode((long)EuclidHashCodeTools.toIntHashCode((double)this.getStartTime(), (double)this.getEndTime()));
            }

            public String toString() {
                return xInterval.toString();
            }
        };
    }

    public static Point3DBasics newLinkedPoint3DBasics(final DoubleProvider xProvider, final DoubleConsumer xConsumer, final DoubleProvider yProvider, final DoubleConsumer yConsumer, final DoubleProvider zProvider, final DoubleConsumer zConsumer) {
        return new Point3DBasics(){

            public void setX(double x) {
                xConsumer.accept(x);
            }

            public void setY(double y) {
                yConsumer.accept(y);
            }

            public void setZ(double z) {
                zConsumer.accept(z);
            }

            public double getX() {
                return xProvider.getValue();
            }

            public double getY() {
                return yProvider.getValue();
            }

            public double getZ() {
                return zProvider.getValue();
            }

            public boolean equals(Object object) {
                if (object == this) {
                    return true;
                }
                if (object instanceof Point3DReadOnly) {
                    return this.equals((EuclidGeometry)((Point3DReadOnly)object));
                }
                return false;
            }

            public int hashCode() {
                return EuclidHashCodeTools.toIntHashCode((long)EuclidHashCodeTools.toIntHashCode((double)this.getX(), (double)this.getY(), (double)this.getZ()));
            }

            public String toString() {
                return EuclidCoreIOTools.getTuple3DString((Tuple3DReadOnly)this);
            }
        };
    }

    public static Vector3DBasics newLinkedVector3DBasics(final DoubleProvider xProvider, final DoubleConsumer xConsumer, final DoubleProvider yProvider, final DoubleConsumer yConsumer, final DoubleProvider zProvider, final DoubleConsumer zConsumer) {
        return new Vector3DBasics(){

            public void setX(double x) {
                xConsumer.accept(x);
            }

            public void setY(double y) {
                yConsumer.accept(y);
            }

            public void setZ(double z) {
                zConsumer.accept(z);
            }

            public double getX() {
                return xProvider.getValue();
            }

            public double getY() {
                return yProvider.getValue();
            }

            public double getZ() {
                return zProvider.getValue();
            }

            public boolean equals(Object object) {
                if (object == this) {
                    return true;
                }
                if (object instanceof Point3DReadOnly) {
                    return this.equals((EuclidGeometry)((Point3DReadOnly)object));
                }
                return false;
            }

            public int hashCode() {
                return EuclidHashCodeTools.toIntHashCode((long)EuclidHashCodeTools.toIntHashCode((double)this.getX(), (double)this.getY(), (double)this.getZ()));
            }

            public String toString() {
                return EuclidCoreIOTools.getTuple3DString((Tuple3DReadOnly)this);
            }
        };
    }
}

