/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.core;

import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.factory.LinearSolverFactory_DDRM;
import org.ejml.interfaces.linsol.LinearSolverDense;
import us.ihmc.robotics.math.trajectories.core.PolynomialTools;
import us.ihmc.robotics.math.trajectories.interfaces.PolynomialBasics;
import us.ihmc.robotics.time.TimeInterval;
import us.ihmc.robotics.time.TimeIntervalBasics;

public class Polynomial
implements PolynomialBasics {
    private final int maximumNumberOfCoefficients;
    private final double[] coefficients;
    private final double[] coefficientsCopy;
    private final DMatrixRMaj constraintMatrix;
    private final DMatrixRMaj constraintVector;
    private final DMatrixRMaj coefficientVector;
    private final LinearSolverDense<DMatrixRMaj> solver;
    private final TimeIntervalBasics timeInterval = new TimeInterval();
    private double currentTime;
    private int numberOfCoefficients;
    private double f;
    private double df;
    private double ddf;
    private final double[] xPowers;
    private final DMatrixRMaj xPowersDerivativeVector;
    private boolean isConstraintMatrixUpToDate = false;

    public Polynomial(int maxNumberOfCoefficients) {
        if (maxNumberOfCoefficients < 1) {
            throw new IllegalArgumentException("You have to make the polynomial to have at least 1 coefficient!");
        }
        this.maximumNumberOfCoefficients = maxNumberOfCoefficients;
        this.coefficients = new double[maxNumberOfCoefficients];
        this.coefficientsCopy = new double[maxNumberOfCoefficients];
        this.constraintMatrix = new DMatrixRMaj(maxNumberOfCoefficients, maxNumberOfCoefficients);
        this.constraintVector = new DMatrixRMaj(maxNumberOfCoefficients, 1);
        this.coefficientVector = new DMatrixRMaj(maxNumberOfCoefficients, 1);
        this.xPowersDerivativeVector = new DMatrixRMaj(1, maxNumberOfCoefficients);
        this.solver = LinearSolverFactory_DDRM.general((int)maxNumberOfCoefficients, (int)maxNumberOfCoefficients);
        this.xPowers = new double[maxNumberOfCoefficients];
        this.reset();
    }

    public Polynomial(double constant) {
        this(new double[]{constant});
    }

    public Polynomial(double coefficient1, double constant) {
        this(new double[]{constant, coefficient1});
    }

    public Polynomial(double coefficient2, double coefficient1, double constant) {
        this(new double[]{constant, coefficient1, coefficient2});
    }

    public Polynomial(double coefficient3, double coefficient2, double coefficient1, double constant) {
        this(new double[]{constant, coefficient1, coefficient2, coefficient3});
    }

    public Polynomial(double tInitial, double tFinal, double[] coefficients) {
        this(tInitial, tFinal, coefficients, true);
    }

    public Polynomial(double[] coefficients) {
        this(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, coefficients, true);
    }

    public Polynomial(double[] coefficients, boolean coefficientsAreLowestOrderFirst) {
        this(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, coefficients, coefficientsAreLowestOrderFirst);
    }

    public Polynomial(double tInitial, double tFinal, double[] coefficients, boolean coefficientsAreLowestOrderFirst) {
        this(coefficients.length);
        this.setNumberOfCoefficients(coefficients.length);
        this.setTime(tInitial, tFinal);
        for (int i = 0; i < Math.min(this.getMaximumNumberOfCoefficients(), this.getNumberOfCoefficients()); ++i) {
            if (coefficientsAreLowestOrderFirst) {
                this.setCoefficient(i, coefficients[i]);
                continue;
            }
            this.setCoefficient(i, coefficients[coefficients.length - 1 - i]);
        }
    }

    public Polynomial(Polynomial other) {
        this.maximumNumberOfCoefficients = other.maximumNumberOfCoefficients;
        this.coefficients = (double[])other.coefficients.clone();
        this.coefficientsCopy = (double[])other.coefficientsCopy.clone();
        this.constraintMatrix = new DMatrixRMaj(other.constraintMatrix);
        this.constraintVector = new DMatrixRMaj(other.constraintVector);
        this.coefficientVector = new DMatrixRMaj(other.coefficientVector);
        this.solver = LinearSolverFactory_DDRM.general((int)other.maximumNumberOfCoefficients, (int)other.maximumNumberOfCoefficients);
        this.timeInterval.setInterval(other.timeInterval.getStartTime(), other.timeInterval.getEndTime());
        this.currentTime = other.currentTime;
        this.numberOfCoefficients = other.numberOfCoefficients;
        this.f = other.f;
        this.df = other.df;
        this.ddf = other.ddf;
        this.xPowers = (double[])other.xPowers.clone();
        this.xPowersDerivativeVector = new DMatrixRMaj(other.xPowersDerivativeVector);
        this.isConstraintMatrixUpToDate = other.isConstraintMatrixUpToDate;
    }

    @Override
    public void compute(double x) {
        int i;
        this.currentTime = x;
        PolynomialTools.setXPowers(this.xPowers, x);
        this.f = 0.0;
        this.df = 0.0;
        this.ddf = 0.0;
        for (i = 0; i < this.numberOfCoefficients; ++i) {
            this.f += this.coefficients[i] * this.xPowers[i];
        }
        for (i = 1; i < this.numberOfCoefficients; ++i) {
            this.df += this.coefficients[i] * (double)i * this.xPowers[i - 1];
        }
        for (i = 2; i < this.numberOfCoefficients; ++i) {
            this.ddf += this.coefficients[i] * (double)(i - 1) * (double)i * this.xPowers[i - 2];
        }
    }

    public double getValue() {
        return this.f;
    }

    @Override
    public double getVelocity() {
        return this.df;
    }

    @Override
    public double getAcceleration() {
        return this.ddf;
    }

    @Override
    public double getCoefficient(int i) {
        return this.coefficients[i];
    }

    @Override
    public void setNumberOfCoefficients(int numberOfCoefficients) {
        this.numberOfCoefficients = numberOfCoefficients;
    }

    @Override
    public void setCurrentTime(double currentTime) {
        this.currentTime = currentTime;
    }

    @Override
    public int getNumberOfCoefficients() {
        return this.numberOfCoefficients;
    }

    @Override
    public double getCurrentTime() {
        return this.currentTime;
    }

    @Override
    public int getMaximumNumberOfCoefficients() {
        return this.maximumNumberOfCoefficients;
    }

    @Override
    public DMatrixRMaj getCoefficientsVector() {
        return this.coefficientVector;
    }

    @Override
    public double[] getCoefficients() {
        this.setCoefficientsCopy();
        return this.coefficientsCopy;
    }

    @Override
    public void solveForCoefficients() {
        this.solver.setA((Matrix)this.constraintMatrix);
        this.solver.solve((Matrix)this.constraintVector, (Matrix)this.coefficientVector);
    }

    @Override
    public void setIsConstraintMatrixUpToDate(boolean isConstraintMatrixUpToDate) {
        this.isConstraintMatrixUpToDate = isConstraintMatrixUpToDate;
    }

    @Override
    public boolean isConstraintMatrixUpToDate() {
        return this.isConstraintMatrixUpToDate;
    }

    public void setDirectly(int power, double coefficient) {
        if (power >= this.getMaximumNumberOfCoefficients()) {
            throw new RuntimeException("Maximum number of coefficients is: " + this.maximumNumberOfCoefficients + ", can't set coefficient as it requires: " + power + "1 coefficients");
        }
        if (power >= this.getNumberOfCoefficients()) {
            for (int i = this.getNumberOfCoefficients(); i <= power; ++i) {
                this.coefficients[i] = 0.0;
            }
            this.coefficientVector.reshape(power + 1, 1);
            this.constraintMatrix.reshape(power + 1, power + 1);
            this.constraintVector.reshape(power + 1, 1);
            this.xPowersDerivativeVector.reshape(1, power + 1);
            this.numberOfCoefficients = power + 1;
        }
        this.setCoefficient(power, coefficient);
    }

    @Override
    public void setConstraintRow(int row, double x, double desiredZDerivative, int derivativeOrderWithPositionBeingZero) {
        double xPower = 1.0;
        for (int col = derivativeOrderWithPositionBeingZero; col < this.numberOfCoefficients; ++col) {
            double columnPower = 1.0;
            for (int i = 0; i < derivativeOrderWithPositionBeingZero; ++i) {
                columnPower *= (double)(col - i);
            }
            this.constraintMatrix.set(row, col, xPower * columnPower);
            xPower *= x;
        }
        this.constraintVector.set(row, 0, desiredZDerivative);
    }

    private void setCoefficientsCopy() {
        int row;
        for (row = 0; row < this.getNumberOfCoefficients(); ++row) {
            this.coefficientsCopy[row] = this.getCoefficient(row);
        }
        while (row < this.getMaximumNumberOfCoefficients()) {
            this.coefficientsCopy[row] = Double.NaN;
            ++row;
        }
    }

    @Override
    public void reshape(int numberOfCoefficientsRequired) {
        if (numberOfCoefficientsRequired > this.getMaximumNumberOfCoefficients()) {
            throw new RuntimeException("Maximum number of coefficients is: " + this.getMaximumNumberOfCoefficients() + ", can't build the polynomial as it requires: " + numberOfCoefficientsRequired + " coefficients.");
        }
        this.coefficientVector.reshape(numberOfCoefficientsRequired, 1);
        this.constraintMatrix.reshape(numberOfCoefficientsRequired, numberOfCoefficientsRequired);
        this.constraintVector.reshape(numberOfCoefficientsRequired, 1);
        this.xPowersDerivativeVector.reshape(1, numberOfCoefficientsRequired);
        this.constraintMatrix.zero();
        this.constraintVector.zero();
        this.coefficientVector.zero();
        this.setNumberOfCoefficients(numberOfCoefficientsRequired);
        for (int i = numberOfCoefficientsRequired; i < this.getMaximumNumberOfCoefficients(); ++i) {
            this.setCoefficient(i, Double.NaN);
        }
    }

    @Override
    public void setCoefficientUnsafe(int idx, double value) {
        this.coefficients[idx] = value;
    }

    public String toString() {
        double tInitial = this.getTimeInterval().getStartTime();
        double tFinal = this.getTimeInterval().getEndTime();
        String inString = "Polynomial: " + this.getCoefficient(0);
        for (int i = 1; i < this.getNumberOfCoefficients(); ++i) {
            inString = inString + " ";
            if (this.getCoefficient(i) >= 0.0) {
                inString = inString + "+";
            }
            inString = inString + this.getCoefficient(i) + " x^" + i;
        }
        return inString + " TInitial: " + tInitial + " TFinal: " + tFinal;
    }

    @Override
    public TimeIntervalBasics getTimeInterval() {
        return this.timeInterval;
    }
}

