/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories;

import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.euclid.tools.EuclidCoreFactories;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.robotics.math.trajectories.PolynomialEstimator;
import us.ihmc.robotics.math.trajectories.interfaces.PositionTrajectoryGenerator;
import us.ihmc.robotics.time.TimeIntervalBasics;
import us.ihmc.robotics.time.TimeIntervalProvider;

public class PolynomialEstimator3D
implements PositionTrajectoryGenerator,
TimeIntervalProvider,
Settable<PolynomialEstimator3D> {
    private static final double defaultWeight = 1.0;
    private final Point3DReadOnly position;
    private final Vector3DReadOnly velocity;
    private final Vector3DReadOnly acceleration;
    private double currentTime = 0.0;
    private final PolynomialEstimator xEstimator = new PolynomialEstimator();
    private final PolynomialEstimator yEstimator = new PolynomialEstimator();
    private final PolynomialEstimator zEstimator = new PolynomialEstimator();

    public PolynomialEstimator3D() {
        this.position = EuclidCoreFactories.newLinkedPoint3DReadOnly(this.xEstimator::getPosition, this.yEstimator::getPosition, this.zEstimator::getPosition);
        this.velocity = EuclidCoreFactories.newLinkedVector3DReadOnly(this.xEstimator::getVelocity, this.yEstimator::getVelocity, this.zEstimator::getVelocity);
        this.acceleration = EuclidCoreFactories.newLinkedVector3DReadOnly(this.xEstimator::getAcceleration, this.yEstimator::getAcceleration, this.zEstimator::getAcceleration);
    }

    public void reset() {
        this.currentTime = Double.NaN;
        this.xEstimator.reset();
        this.yEstimator.reset();
        this.zEstimator.reset();
    }

    public void reshape(int order) {
        this.xEstimator.reshape(order);
        this.yEstimator.reshape(order);
        this.zEstimator.reshape(order);
    }

    public void set(PolynomialEstimator3D other) {
        this.xEstimator.set(other.xEstimator);
        this.yEstimator.set(other.yEstimator);
        this.zEstimator.set(other.zEstimator);
    }

    @Override
    public TimeIntervalBasics getTimeInterval() {
        return this.xEstimator.getTimeInterval();
    }

    public void addObjectivePosition(double time, Tuple3DReadOnly value) {
        this.addObjectivePosition(1.0, time, value);
    }

    public void addObjectivePosition(double weight, double time, Tuple3DReadOnly value) {
        this.xEstimator.addObjectivePosition(weight, time, value.getX());
        this.yEstimator.addObjectivePosition(weight, time, value.getY());
        this.zEstimator.addObjectivePosition(weight, time, value.getZ());
    }

    public void addObjectiveVelocity(double time, Tuple3DReadOnly value) {
        this.addObjectiveVelocity(1.0, time, value);
    }

    public void addObjectiveVelocity(double weight, double time, Tuple3DReadOnly value) {
        this.xEstimator.addObjectiveVelocity(weight, time, value.getX());
        this.yEstimator.addObjectiveVelocity(weight, time, value.getY());
        this.zEstimator.addObjectiveVelocity(weight, time, value.getZ());
    }

    public void addConstraintPosition(double time, Tuple3DReadOnly value) {
        this.xEstimator.addConstraintPosition(time, value.getX());
        this.yEstimator.addConstraintPosition(time, value.getY());
        this.zEstimator.addConstraintPosition(time, value.getZ());
    }

    public void addConstraintVelocity(double time, Tuple3DReadOnly value) {
        this.xEstimator.addConstraintVelocity(time, value.getX());
        this.yEstimator.addConstraintVelocity(time, value.getY());
        this.zEstimator.addConstraintVelocity(time, value.getZ());
    }

    @Override
    public void initialize() {
        this.xEstimator.solve();
        this.yEstimator.solve();
        this.zEstimator.solve();
    }

    @Override
    public void compute(double time) {
        this.currentTime = time;
        this.xEstimator.compute(time);
        this.yEstimator.compute(time);
        this.zEstimator.compute(time);
    }

    @Override
    public Point3DReadOnly getPosition() {
        return this.position;
    }

    @Override
    public Vector3DReadOnly getVelocity() {
        return this.velocity;
    }

    @Override
    public Vector3DReadOnly getAcceleration() {
        return this.acceleration;
    }

    @Override
    public boolean isDone() {
        return this.currentTime >= this.getTimeInterval().getEndTime();
    }

    @Override
    public void showVisualization() {
    }

    @Override
    public void hideVisualization() {
    }
}

