/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories;

import us.ihmc.commons.MathTools;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.robotics.math.trajectories.interfaces.FixedFramePositionTrajectoryGenerator;
import us.ihmc.robotics.math.trajectories.interfaces.PolynomialBasics;
import us.ihmc.robotics.math.trajectories.yoVariables.YoParabolicTrajectoryGenerator;
import us.ihmc.robotics.math.trajectories.yoVariables.YoPolynomial;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class ParabolicCartesianTrajectoryGenerator
implements FixedFramePositionTrajectoryGenerator {
    private final String namePostFix = this.getClass().getSimpleName();
    private final YoRegistry registry;
    private final PolynomialBasics minimumJerkTrajectory;
    private final YoParabolicTrajectoryGenerator parabolicTrajectoryGenerator;
    protected final YoDouble groundClearance;
    private final YoDouble stepTime;
    private final YoDouble timeIntoStep;
    private final DoubleProvider stepTimeProvider;
    private final FrameVector3D tempVector = new FrameVector3D(ReferenceFrame.getWorldFrame());
    private final FramePoint3D desiredPosition;
    private final FrameVector3D desiredVelocity;
    private final FrameVector3D desiredAcceleration;
    private final FramePoint3D initialDesiredPosition = new FramePoint3D();
    private final FramePoint3D finalDesiredPosition = new FramePoint3D();

    public ParabolicCartesianTrajectoryGenerator(String namePrefix, ReferenceFrame referenceFrame, DoubleProvider stepTimeProvider, double groundClearance, YoRegistry parentRegistry) {
        this.registry = new YoRegistry(namePrefix + this.namePostFix);
        this.minimumJerkTrajectory = new YoPolynomial(namePrefix, 6, this.registry);
        this.parabolicTrajectoryGenerator = new YoParabolicTrajectoryGenerator(namePrefix, referenceFrame, this.registry);
        this.groundClearance = new YoDouble("groundClearance", this.registry);
        this.stepTime = new YoDouble("stepTime", this.registry);
        this.timeIntoStep = new YoDouble("timeIntoStep", this.registry);
        parentRegistry.addChild(this.registry);
        this.desiredPosition = new FramePoint3D(referenceFrame);
        this.desiredVelocity = new FrameVector3D(referenceFrame);
        this.desiredAcceleration = new FrameVector3D(referenceFrame);
        this.stepTimeProvider = stepTimeProvider;
        this.groundClearance.set(groundClearance);
    }

    public void setInitialDesiredPosition(FramePoint3DReadOnly initialDesiredPosition) {
        this.initialDesiredPosition.setIncludingFrame((FrameTuple3DReadOnly)initialDesiredPosition);
    }

    public void setFinalDesiredPosition(FramePoint3DReadOnly finalDesiredPosition) {
        this.finalDesiredPosition.setIncludingFrame((FrameTuple3DReadOnly)finalDesiredPosition);
    }

    @Override
    public ReferenceFrame getReferenceFrame() {
        return this.parabolicTrajectoryGenerator.getReferenceFrame();
    }

    @Override
    public boolean isDone() {
        return this.timeIntoStep.getDoubleValue() >= this.stepTime.getDoubleValue();
    }

    public double getFinalTime() {
        return this.stepTime.getDoubleValue();
    }

    public void updateGroundClearance(double newGroundClearance) {
        this.groundClearance.set(newGroundClearance);
    }

    public double getCurrentGroundClearance() {
        return this.groundClearance.getDoubleValue();
    }

    @Override
    public FramePoint3DReadOnly getPosition() {
        double parameter = this.minimumJerkTrajectory.getValue();
        parameter = MathTools.clamp((double)parameter, (double)0.0, (double)1.0);
        this.parabolicTrajectoryGenerator.getPosition(this.desiredPosition, parameter);
        return this.desiredPosition;
    }

    @Override
    public FrameVector3DReadOnly getVelocity() {
        double parameter = this.minimumJerkTrajectory.getValue();
        parameter = MathTools.clamp((double)parameter, (double)0.0, (double)1.0);
        this.parabolicTrajectoryGenerator.getVelocity(this.tempVector, parameter);
        this.desiredVelocity.setIncludingFrame((FrameTuple3DReadOnly)this.tempVector);
        this.desiredVelocity.scale(this.minimumJerkTrajectory.getVelocity());
        return this.desiredVelocity;
    }

    @Override
    public FrameVector3DReadOnly getAcceleration() {
        double parameter = this.minimumJerkTrajectory.getValue();
        parameter = MathTools.clamp((double)parameter, (double)0.0, (double)1.0);
        this.parabolicTrajectoryGenerator.getAcceleration(this.desiredAcceleration);
        this.desiredAcceleration.scale(this.minimumJerkTrajectory.getVelocity() * this.minimumJerkTrajectory.getVelocity());
        this.parabolicTrajectoryGenerator.getVelocity(this.tempVector, parameter);
        this.tempVector.scale(this.minimumJerkTrajectory.getAcceleration());
        this.desiredAcceleration.add((FrameTuple3DReadOnly)this.tempVector);
        return this.desiredAcceleration;
    }

    @Override
    public void showVisualization() {
    }

    @Override
    public void hideVisualization() {
    }

    public void computeNextTick(FramePoint3D positionToPack, double deltaT) {
        this.timeIntoStep.add(deltaT);
        this.compute(this.timeIntoStep.getDoubleValue());
        positionToPack.setIncludingFrame((FrameTuple3DReadOnly)this.getPosition());
    }

    @Override
    public void initialize() {
        this.timeIntoStep.set(0.0);
        this.stepTime.set(this.stepTimeProvider.getValue());
        if (this.stepTime.getDoubleValue() < 1.0E-10) {
            this.stepTime.set(1.0E-10);
        }
        this.minimumJerkTrajectory.setQuintic(0.0, this.stepTime.getDoubleValue(), 0.0, 0.0, 0.0, 1.0, 0.0, 0.0);
        double middleOfTrajectoryParameter = 0.5;
        this.parabolicTrajectoryGenerator.initialize((FramePoint3DReadOnly)this.initialDesiredPosition, (FramePoint3DReadOnly)this.finalDesiredPosition, this.groundClearance.getDoubleValue(), middleOfTrajectoryParameter);
    }

    @Override
    public void compute(double time) {
        this.timeIntoStep.set(time);
        this.minimumJerkTrajectory.compute(time);
    }

    public YoDouble getTimeIntoStep() {
        return this.timeIntoStep;
    }
}

