/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories;

import org.apache.commons.math3.util.Precision;
import us.ihmc.commons.MathTools;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameQuaternionBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple4DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameFactories;
import us.ihmc.euclid.tools.QuaternionTools;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.Vector4D;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Tuple4DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DBasics;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DReadOnly;
import us.ihmc.robotics.math.trajectories.interfaces.FrameOrientationTrajectoryGenerator;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.FrameSO3TrajectoryPointReadOnly;
import us.ihmc.yoVariables.euclid.YoQuaternion;
import us.ihmc.yoVariables.euclid.YoVector3D;
import us.ihmc.yoVariables.euclid.referenceFrame.interfaces.FrameIndexMap;
import us.ihmc.yoVariables.euclid.referenceFrame.interfaces.YoMutableFrameObject;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.tools.YoGeometryNameTools;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;
import us.ihmc.yoVariables.variable.YoLong;

public class HermiteCurveBasedOrientationTrajectoryGenerator
implements FrameOrientationTrajectoryGenerator,
YoMutableFrameObject {
    private final YoRegistry registry;
    private final YoDouble currentTime;
    private final YoDouble trajectoryTime;
    private final YoInteger numberOfRevolutions;
    private final YoDouble[] cumulativeBeziers;
    private final YoDouble[] cumulativeBeziersDot;
    private final YoDouble[] cumulativeBeziersDDot;
    private final YoLong frameId;
    private final FrameIndexMap frameIndexMap;
    private final FixedFrameVector3DBasics controlRotation1;
    private final FixedFrameVector3DBasics controlRotation2;
    private final FixedFrameVector3DBasics controlRotation3;
    private final FixedFrameQuaternionBasics initialOrientation;
    private final FixedFrameVector3DBasics initialAngularVelocity;
    private final FixedFrameQuaternionBasics finalOrientation;
    private final FixedFrameVector3DBasics finalAngularVelocity;
    private final FixedFrameQuaternionBasics currentOrientation;
    private final FixedFrameVector3DBasics currentAngularVelocity;
    private final FixedFrameVector3DBasics currentAngularAcceleration;
    private final Quaternion tempQuaternion = new Quaternion();
    private final Vector3D wa = new Vector3D();
    private final Vector3D wb = new Vector3D();
    private final Vector3D delta = new Vector3D();
    private final Quaternion qInterpolated = new Quaternion();
    private final Vector3D angularVelocityInterpolated = new Vector3D();
    private final Vector3D angularAccelerationInterpolated = new Vector3D();
    private final Quaternion qProduct = new Quaternion();
    private final Vector4D qDot = new Vector4D();
    private final Vector4D qDot1 = new Vector4D();
    private final Vector4D qDot2 = new Vector4D();
    private final Vector4D qDot3 = new Vector4D();
    private final Vector4D qProductDot = new Vector4D();
    private final Vector4D qDDot = new Vector4D();
    private final Vector4D qDDot1 = new Vector4D();
    private final Vector4D qDDot2 = new Vector4D();
    private final Vector4D qDDot3 = new Vector4D();
    private final Vector4D qDDotTemp = new Vector4D();
    private final Vector4D qProductDDot = new Vector4D();
    private final Vector3D d1 = new Vector3D();
    private final Vector3D d2 = new Vector3D();
    private final Vector3D d3 = new Vector3D();
    private final Quaternion expD1B1 = new Quaternion();
    private final Quaternion expD2B2 = new Quaternion();
    private final Quaternion expD1B1_expD2B2 = new Quaternion();
    private final Quaternion expD3B3 = new Quaternion();
    private final Vector4D d1B1Dot = new Vector4D();
    private final Vector4D d2B2Dot = new Vector4D();
    private final Vector4D d3B3Dot = new Vector4D();
    private final Vector4D d1B1DDot = new Vector4D();
    private final Vector4D d2B2DDot = new Vector4D();
    private final Vector4D d3B3DDot = new Vector4D();
    private final Quaternion tempLogExpQuaternion = new Quaternion();
    private final Vector3D tempLogExpVector3D = new Vector3D();
    private final Vector3D tempConvertVector3D = new Vector3D();
    private final Vector4D tempConvertVector4D = new Vector4D();

    public HermiteCurveBasedOrientationTrajectoryGenerator(String name, ReferenceFrame referenceFrame, YoRegistry parentRegistry) {
        this.registry = new YoRegistry(name);
        this.frameId = new YoLong(YoGeometryNameTools.assembleName((String[])new String[]{name, "frame"}), this.registry);
        this.frameIndexMap = new FrameIndexMap.FrameIndexHashMap();
        this.trajectoryTime = new YoDouble(name + "TrajectoryTime", this.registry);
        this.numberOfRevolutions = new YoInteger(name + "NumberOfRevolutions", this.registry);
        this.currentTime = new YoDouble(name + "Time", this.registry);
        this.cumulativeBeziers = new YoDouble[4];
        this.cumulativeBeziersDot = new YoDouble[4];
        this.cumulativeBeziersDDot = new YoDouble[4];
        for (int i = 1; i <= 3; ++i) {
            this.cumulativeBeziers[i] = new YoDouble(name + "CumulativeBezier" + i, this.registry);
            this.cumulativeBeziersDot[i] = new YoDouble(name + "CumulativeBezierDot" + i, this.registry);
            this.cumulativeBeziersDDot[i] = new YoDouble(name + "CumulativeBezierDDot" + i, this.registry);
        }
        String initialOrientationName = "InitialOrientation";
        String initialAngularVelocityName = "InitialAngularVelocity";
        String finalOrientationName = "FinalOrientation";
        String finalAngularVelocityName = "FinalAngularVelocity";
        String currentOrientationName = "CurrentOrientation";
        String currentAngularVelocityName = "CurrentAngularVelocity";
        String currentAngularAccelerationName = "CurrentAngularAcceleration";
        String controlRotationsName = "ControlRotations";
        this.initialOrientation = EuclidFrameFactories.newLinkedFixedFrameQuaternionBasics((ReferenceFrameHolder)this, (QuaternionBasics)new YoQuaternion(name + initialOrientationName, this.registry));
        this.initialAngularVelocity = EuclidFrameFactories.newLinkedFixedFrameVector3DBasics((ReferenceFrameHolder)this, (Vector3DBasics)new YoVector3D(name + initialAngularVelocityName, this.registry));
        this.finalOrientation = EuclidFrameFactories.newLinkedFixedFrameQuaternionBasics((ReferenceFrameHolder)this, (QuaternionBasics)new YoQuaternion(name + finalOrientationName, this.registry));
        this.finalAngularVelocity = EuclidFrameFactories.newLinkedFixedFrameVector3DBasics((ReferenceFrameHolder)this, (Vector3DBasics)new YoVector3D(name + finalAngularVelocityName, this.registry));
        this.currentOrientation = EuclidFrameFactories.newLinkedFixedFrameQuaternionBasics((ReferenceFrameHolder)this, (QuaternionBasics)new YoQuaternion(name + currentOrientationName, this.registry));
        this.currentAngularVelocity = EuclidFrameFactories.newLinkedFixedFrameVector3DBasics((ReferenceFrameHolder)this, (Vector3DBasics)new YoVector3D(name + currentAngularVelocityName, this.registry));
        this.currentAngularAcceleration = EuclidFrameFactories.newLinkedFixedFrameVector3DBasics((ReferenceFrameHolder)this, (Vector3DBasics)new YoVector3D(name + currentAngularAccelerationName, this.registry));
        this.controlRotation1 = EuclidFrameFactories.newLinkedFixedFrameVector3DBasics((ReferenceFrameHolder)this, (Vector3DBasics)new YoVector3D(name + controlRotationsName + "1", this.registry));
        this.controlRotation2 = EuclidFrameFactories.newLinkedFixedFrameVector3DBasics((ReferenceFrameHolder)this, (Vector3DBasics)new YoVector3D(name + controlRotationsName + "2", this.registry));
        this.controlRotation3 = EuclidFrameFactories.newLinkedFixedFrameVector3DBasics((ReferenceFrameHolder)this, (Vector3DBasics)new YoVector3D(name + controlRotationsName + "3", this.registry));
        this.clear(referenceFrame);
        parentRegistry.addChild(this.registry);
    }

    public void clear(ReferenceFrame referenceFrame) {
        this.clear();
        this.setReferenceFrame(referenceFrame);
    }

    public void clear() {
        this.currentTime.setToNaN();
        this.trajectoryTime.setToNaN();
        for (int i = 1; i <= 3; ++i) {
            this.cumulativeBeziers[i].setToNaN();
            this.cumulativeBeziersDot[i].setToNaN();
            this.cumulativeBeziersDDot[i].setToNaN();
        }
        this.initialOrientation.setToNaN();
        this.initialAngularVelocity.setToNaN();
        this.finalOrientation.setToNaN();
        this.finalAngularVelocity.setToNaN();
        this.currentOrientation.setToNaN();
        this.currentAngularVelocity.setToNaN();
        this.currentAngularAcceleration.setToNaN();
    }

    public void setTrajectoryTime(double duration) {
        MathTools.checkIntervalContains((double)duration, (double)0.0, (double)Double.POSITIVE_INFINITY);
        this.trajectoryTime.set(duration);
    }

    public void setInitialOrientation(FrameOrientation3DReadOnly initialOrientation) {
        this.initialOrientation.setMatchingFrame(initialOrientation);
    }

    public void setFinalOrientation(FrameOrientation3DReadOnly finalOrientation) {
        this.finalOrientation.setMatchingFrame(finalOrientation);
    }

    public void setFinalOrientation(FramePose3D finalPose) {
        this.finalOrientation.setMatchingFrame((FrameQuaternionReadOnly)finalPose.getOrientation());
    }

    public void setInitialAngularVelocity(FrameVector3DReadOnly initialAngularVelocity) {
        this.initialAngularVelocity.setMatchingFrame((FrameTuple3DReadOnly)initialAngularVelocity);
    }

    public void setFinalAngularVelocity(FrameVector3DReadOnly finalAngularVelocity) {
        this.finalAngularVelocity.setMatchingFrame((FrameTuple3DReadOnly)finalAngularVelocity);
    }

    public void setInitialVelocityToZero() {
        this.initialAngularVelocity.setToZero();
    }

    public void setFinalVelocityToZero() {
        this.finalAngularVelocity.setToZero();
    }

    public FixedFrameQuaternionBasics getInitialOrientation() {
        return this.initialOrientation;
    }

    public FixedFrameVector3DBasics getInitialAngularVelocity() {
        return this.initialAngularVelocity;
    }

    public FixedFrameQuaternionBasics getFinalOrientation() {
        return this.finalOrientation;
    }

    public FixedFrameVector3DBasics getFinalAngularVelocity() {
        return this.finalAngularVelocity;
    }

    public void setNumberOfRevolutions(int numberOfRevolutions) {
        this.numberOfRevolutions.set(numberOfRevolutions);
    }

    public void setInitialConditions(FrameOrientation3DReadOnly initialOrientation, FrameVector3DReadOnly initialAngularVelocity) {
        this.setInitialOrientation(initialOrientation);
        this.setInitialAngularVelocity(initialAngularVelocity);
    }

    public void setFinalConditions(FrameOrientation3DReadOnly finalOrientation, FrameVector3DReadOnly finalAngularVelocity) {
        this.setFinalOrientation(finalOrientation);
        this.setFinalAngularVelocity(finalAngularVelocity);
    }

    public void setTrajectoryParameters(FrameSO3TrajectoryPointReadOnly initialYoFrameSO3Waypoint, FrameSO3TrajectoryPointReadOnly finalYoFrameSO3Waypoint) {
        this.setTrajectoryTime(finalYoFrameSO3Waypoint.getTime() - initialYoFrameSO3Waypoint.getTime());
        this.initialOrientation.set(initialYoFrameSO3Waypoint.getOrientation());
        this.initialAngularVelocity.set((FrameTuple3DReadOnly)initialYoFrameSO3Waypoint.getAngularVelocity());
        this.finalOrientation.set(finalYoFrameSO3Waypoint.getOrientation());
        this.finalAngularVelocity.set((FrameTuple3DReadOnly)finalYoFrameSO3Waypoint.getAngularVelocity());
    }

    @Override
    public void initialize() {
        if (this.initialOrientation.dot((FrameTuple4DReadOnly)this.finalOrientation) < 0.0) {
            this.finalOrientation.negate();
        }
        this.updateControlQuaternions();
        this.compute(0.0);
    }

    private void updateControlQuaternions() {
        double TOverThree = this.trajectoryTime.getDoubleValue() / 3.0;
        FixedFrameQuaternionBasics qa = this.initialOrientation;
        FixedFrameQuaternionBasics qb = this.finalOrientation;
        this.wa.set((Tuple3DReadOnly)this.initialAngularVelocity);
        this.wb.set((Tuple3DReadOnly)this.finalAngularVelocity);
        qa.inverseTransform((Tuple3DBasics)this.wa);
        qb.inverseTransform((Tuple3DBasics)this.wb);
        this.delta.setAndScale(TOverThree, (Tuple3DReadOnly)this.wa);
        this.controlRotation1.set((Tuple3DReadOnly)this.delta);
        this.tempQuaternion.difference((QuaternionReadOnly)qa, (QuaternionReadOnly)qb);
        this.tempQuaternion.preMultiply(this.exp(-TOverThree, (Vector3DReadOnly)this.wa));
        this.tempQuaternion.multiply(this.exp(-TOverThree, (Vector3DReadOnly)this.wb));
        this.controlRotation2.set((Tuple3DReadOnly)this.log((QuaternionReadOnly)this.tempQuaternion));
        if (this.numberOfRevolutions.getIntegerValue() != 0) {
            this.delta.set((Tuple3DReadOnly)this.controlRotation2);
            if (this.delta.normSquared() > 1.0E-10) {
                this.delta.normalize();
                this.delta.scale((double)this.numberOfRevolutions.getIntegerValue() * 2.0 * Math.PI);
                this.controlRotation2.add((Tuple3DReadOnly)this.delta);
            }
        }
        this.delta.setAndScale(TOverThree, (Tuple3DReadOnly)this.wb);
        this.controlRotation3.set((Tuple3DReadOnly)this.delta);
    }

    @Override
    public void compute(double time) {
        if (Double.isNaN(time)) {
            throw new RuntimeException("Can not call compute on trajectory generator with time NaN.");
        }
        this.currentTime.set(time);
        if (time < 0.0) {
            this.currentOrientation.set((FrameQuaternionReadOnly)this.initialOrientation);
            this.currentAngularVelocity.setToZero();
            this.currentAngularAcceleration.setToZero();
            return;
        }
        if (time > this.trajectoryTime.getDoubleValue()) {
            this.currentOrientation.set((FrameQuaternionReadOnly)this.finalOrientation);
            this.currentAngularVelocity.setToZero();
            this.currentAngularAcceleration.setToZero();
            return;
        }
        if (Precision.equals((double)0.0, (double)this.trajectoryTime.getDoubleValue())) {
            this.currentOrientation.set((FrameQuaternionReadOnly)this.initialOrientation);
            this.currentAngularVelocity.set((FrameTuple3DReadOnly)this.initialAngularVelocity);
            this.currentAngularAcceleration.setToZero();
            return;
        }
        time = MathTools.clamp((double)time, (double)0.0, (double)this.trajectoryTime.getDoubleValue());
        this.computeBezierBasedCurve(time, (QuaternionBasics)this.qInterpolated, this.angularVelocityInterpolated, this.angularAccelerationInterpolated);
        this.currentOrientation.set((QuaternionReadOnly)this.qInterpolated);
        this.currentAngularVelocity.set((Tuple3DReadOnly)this.angularVelocityInterpolated);
        this.currentAngularAcceleration.set((Tuple3DReadOnly)this.angularAccelerationInterpolated);
    }

    private void updateBezierCoefficients(double t) {
        double T = this.trajectoryTime.getDoubleValue();
        double oneOverT = 1.0 / T;
        double tOverT = t * oneOverT;
        this.cumulativeBeziers[1].set(1.0 - HermiteCurveBasedOrientationTrajectoryGenerator.cube(1.0 - tOverT));
        this.cumulativeBeziers[2].set(3.0 * MathTools.square((double)tOverT) - 2.0 * HermiteCurveBasedOrientationTrajectoryGenerator.cube(tOverT));
        this.cumulativeBeziers[3].set(HermiteCurveBasedOrientationTrajectoryGenerator.cube(tOverT));
        this.cumulativeBeziersDot[1].set(3.0 * oneOverT * MathTools.square((double)(1.0 - tOverT)));
        this.cumulativeBeziersDot[2].set(6.0 * tOverT * oneOverT * (1.0 - tOverT));
        this.cumulativeBeziersDot[3].set(3.0 * MathTools.square((double)tOverT) * oneOverT);
        this.cumulativeBeziersDDot[1].set(-6.0 * MathTools.square((double)oneOverT) * (1.0 - tOverT));
        this.cumulativeBeziersDDot[2].set(6.0 * MathTools.square((double)oneOverT) * (1.0 - 2.0 * tOverT));
        this.cumulativeBeziersDDot[3].set(6.0 * t * HermiteCurveBasedOrientationTrajectoryGenerator.cube(oneOverT));
    }

    private static double cube(double value) {
        return value * value * value;
    }

    private void computeBezierBasedCurve(double time, QuaternionBasics q, Vector3D angularVelocity, Vector3D angularAcceleration) {
        this.updateBezierCoefficients(time);
        FixedFrameQuaternionBasics q0 = this.initialOrientation;
        this.d1.set((Tuple3DReadOnly)this.controlRotation1);
        this.d2.set((Tuple3DReadOnly)this.controlRotation2);
        this.d3.set((Tuple3DReadOnly)this.controlRotation3);
        this.expD1B1.set(this.exp(this.cumulativeBeziers[1].getDoubleValue(), (Vector3DReadOnly)this.d1));
        this.expD2B2.set(this.exp(this.cumulativeBeziers[2].getDoubleValue(), (Vector3DReadOnly)this.d2));
        this.expD3B3.set(this.exp(this.cumulativeBeziers[3].getDoubleValue(), (Vector3DReadOnly)this.d3));
        this.expD1B1_expD2B2.set(this.expD1B1);
        this.expD1B1_expD2B2.multiply((QuaternionReadOnly)this.expD2B2);
        this.d1B1Dot.set((Vector3DReadOnly)this.d1);
        this.d2B2Dot.set((Vector3DReadOnly)this.d2);
        this.d3B3Dot.set((Vector3DReadOnly)this.d3);
        this.d1B1Dot.scale(0.5 * this.cumulativeBeziersDot[1].getDoubleValue());
        this.d2B2Dot.scale(0.5 * this.cumulativeBeziersDot[2].getDoubleValue());
        this.d3B3Dot.scale(0.5 * this.cumulativeBeziersDot[3].getDoubleValue());
        this.d1B1DDot.set((Vector3DReadOnly)this.d1);
        this.d2B2DDot.set((Vector3DReadOnly)this.d2);
        this.d3B3DDot.set((Vector3DReadOnly)this.d3);
        this.d1B1DDot.scale(0.5 * this.cumulativeBeziersDDot[1].getDoubleValue());
        this.d2B2DDot.scale(0.5 * this.cumulativeBeziersDDot[2].getDoubleValue());
        this.d3B3DDot.scale(0.5 * this.cumulativeBeziersDDot[3].getDoubleValue());
        this.qProduct.set(this.expD1B1);
        this.qProduct.multiply((QuaternionReadOnly)this.expD2B2);
        this.qProduct.multiply((QuaternionReadOnly)this.expD3B3);
        QuaternionTools.multiply((Tuple4DReadOnly)this.d1B1Dot, (Tuple4DReadOnly)this.qProduct, (Vector4DBasics)this.qDot1);
        QuaternionTools.multiply((Tuple4DReadOnly)this.expD1B1_expD2B2, (Tuple4DReadOnly)this.d2B2Dot, (Vector4DBasics)this.qDot2);
        QuaternionTools.multiply((Tuple4DReadOnly)this.qDot2, (Tuple4DReadOnly)this.expD3B3, (Vector4DBasics)this.qDot2);
        QuaternionTools.multiply((Tuple4DReadOnly)this.qProduct, (Tuple4DReadOnly)this.d3B3Dot, (Vector4DBasics)this.qDot3);
        this.qProductDot.add((Tuple4DReadOnly)this.qDot1, (Tuple4DReadOnly)this.qDot2);
        this.qProductDot.add((Tuple4DReadOnly)this.qDot3);
        QuaternionTools.multiply((Tuple4DReadOnly)this.d1B1DDot, (Tuple4DReadOnly)this.qProduct, (Vector4DBasics)this.qDDotTemp);
        QuaternionTools.multiply((Tuple4DReadOnly)this.d1B1Dot, (Tuple4DReadOnly)this.qProductDot, (Vector4DBasics)this.qDDot1);
        this.qDDot1.add((Tuple4DReadOnly)this.qDDotTemp);
        QuaternionTools.multiply((Tuple4DReadOnly)this.d2B2Dot, (Tuple4DReadOnly)this.d2B2Dot, (Vector4DBasics)this.qDDot2);
        this.qDDot2.add((Tuple4DReadOnly)this.d2B2DDot);
        QuaternionTools.multiply((Tuple4DReadOnly)this.expD1B1_expD2B2, (Tuple4DReadOnly)this.qDDot2, (Vector4DBasics)this.qDDotTemp);
        QuaternionTools.multiply((Tuple4DReadOnly)this.qDDotTemp, (Tuple4DReadOnly)this.expD3B3, (Vector4DBasics)this.qDDotTemp);
        this.qDDot2.set(this.qDDotTemp);
        QuaternionTools.multiply((Tuple4DReadOnly)this.d1B1Dot, (Tuple4DReadOnly)this.qDot2, (Vector4DBasics)this.qDDotTemp);
        this.qDDot2.add((Tuple4DReadOnly)this.qDDotTemp);
        QuaternionTools.multiply((Tuple4DReadOnly)this.qDot2, (Tuple4DReadOnly)this.d3B3Dot, (Vector4DBasics)this.qDDotTemp);
        this.qDDot2.add((Tuple4DReadOnly)this.qDDotTemp);
        QuaternionTools.multiply((Tuple4DReadOnly)this.qProduct, (Tuple4DReadOnly)this.d3B3DDot, (Vector4DBasics)this.qDDotTemp);
        QuaternionTools.multiply((Tuple4DReadOnly)this.qProductDot, (Tuple4DReadOnly)this.d3B3Dot, (Vector4DBasics)this.qDDot3);
        this.qDDot3.add((Tuple4DReadOnly)this.qDDotTemp);
        this.qProductDDot.add((Tuple4DReadOnly)this.qDDot1, (Tuple4DReadOnly)this.qDDot2);
        this.qProductDDot.add((Tuple4DReadOnly)this.qDDot3);
        q.multiply((QuaternionReadOnly)q0, (QuaternionReadOnly)this.qProduct);
        QuaternionTools.multiply((Tuple4DReadOnly)q0, (Tuple4DReadOnly)this.qProductDot, (Vector4DBasics)this.qDot);
        QuaternionTools.multiply((Tuple4DReadOnly)q0, (Tuple4DReadOnly)this.qProductDDot, (Vector4DBasics)this.qDDot);
        angularVelocity.set((Tuple3DReadOnly)this.convertToAngularVelocity((QuaternionReadOnly)q, (Vector4DReadOnly)this.qDot));
        angularAcceleration.set((Tuple3DReadOnly)this.convertToAngularAcceleration((QuaternionReadOnly)q, (Vector4DReadOnly)this.qDot, (Vector4DReadOnly)this.qDDot));
    }

    private QuaternionReadOnly exp(double alpha, Vector3DReadOnly rotation) {
        this.tempLogExpVector3D.setAndScale(alpha, (Tuple3DReadOnly)rotation);
        this.tempLogExpQuaternion.setRotationVector((Vector3DReadOnly)this.tempLogExpVector3D);
        return this.tempLogExpQuaternion;
    }

    private Vector3DReadOnly log(QuaternionReadOnly q) {
        q.getRotationVector((Vector3DBasics)this.tempLogExpVector3D);
        return this.tempLogExpVector3D;
    }

    private Vector3DReadOnly convertToAngularVelocity(QuaternionReadOnly q, Vector4DReadOnly qDot) {
        QuaternionTools.multiplyConjugateRight((Tuple4DReadOnly)qDot, (Tuple4DReadOnly)q, (Vector4DBasics)this.tempConvertVector4D);
        this.tempConvertVector3D.setX(this.tempConvertVector4D.getX());
        this.tempConvertVector3D.setY(this.tempConvertVector4D.getY());
        this.tempConvertVector3D.setZ(this.tempConvertVector4D.getZ());
        this.tempConvertVector3D.scale(2.0);
        return this.tempConvertVector3D;
    }

    private Vector3DReadOnly convertToAngularAcceleration(QuaternionReadOnly q, Vector4DReadOnly qDot, Vector4DReadOnly qDDot) {
        QuaternionTools.multiplyConjugateRight((Tuple4DReadOnly)qDDot, (Tuple4DReadOnly)q, (Vector4DBasics)this.tempConvertVector4D);
        this.tempConvertVector3D.setX(this.tempConvertVector4D.getX());
        this.tempConvertVector3D.setY(this.tempConvertVector4D.getY());
        this.tempConvertVector3D.setZ(this.tempConvertVector4D.getZ());
        QuaternionTools.multiplyConjugateRight((Tuple4DReadOnly)qDot, (Tuple4DReadOnly)qDot, (Vector4DBasics)this.tempConvertVector4D);
        this.tempConvertVector3D.addX(this.tempConvertVector4D.getX());
        this.tempConvertVector3D.addY(this.tempConvertVector4D.getY());
        this.tempConvertVector3D.addZ(this.tempConvertVector4D.getZ());
        this.tempConvertVector3D.scale(2.0);
        return this.tempConvertVector3D;
    }

    @Override
    public boolean isDone() {
        return this.currentTime.getDoubleValue() >= this.trajectoryTime.getDoubleValue();
    }

    public FrameQuaternionReadOnly getOrientation() {
        return this.currentOrientation;
    }

    @Override
    public FrameVector3DReadOnly getAngularVelocity() {
        return this.currentAngularVelocity;
    }

    @Override
    public FrameVector3DReadOnly getAngularAcceleration() {
        return this.currentAngularAcceleration;
    }

    @Override
    public ReferenceFrame getReferenceFrame() {
        return super.getReferenceFrame();
    }

    public YoLong getYoFrameIndex() {
        return this.frameId;
    }

    public FrameIndexMap getFrameIndexMap() {
        return this.frameIndexMap;
    }

    public void setReferenceFrame(ReferenceFrame referenceFrame) {
        super.setReferenceFrame(referenceFrame);
    }

    public void applyTransform(Transform transform) {
        this.initialOrientation.applyTransform(transform);
        this.initialAngularVelocity.applyTransform(transform);
        this.finalOrientation.applyTransform(transform);
        this.finalAngularVelocity.applyTransform(transform);
        this.currentOrientation.applyTransform(transform);
        this.currentAngularVelocity.applyTransform(transform);
        this.currentAngularAcceleration.applyTransform(transform);
        this.controlRotation1.applyTransform(transform);
        this.controlRotation2.applyTransform(transform);
        this.controlRotation3.applyTransform(transform);
    }

    public void applyInverseTransform(Transform transform) {
        this.initialOrientation.applyInverseTransform(transform);
        this.initialAngularVelocity.applyInverseTransform(transform);
        this.finalOrientation.applyInverseTransform(transform);
        this.finalAngularVelocity.applyInverseTransform(transform);
        this.currentOrientation.applyInverseTransform(transform);
        this.currentAngularVelocity.applyInverseTransform(transform);
        this.currentAngularAcceleration.applyInverseTransform(transform);
        this.controlRotation1.applyInverseTransform(transform);
        this.controlRotation2.applyInverseTransform(transform);
        this.controlRotation3.applyInverseTransform(transform);
    }

    public String toString() {
        Object ret = "";
        ret = (String)ret + "Current time: " + this.currentTime.getDoubleValue() + ", trajectory time: " + this.trajectoryTime.getDoubleValue();
        ret = (String)ret + "\nCurrent orientation: " + this.currentOrientation.toString();
        ret = (String)ret + "\nCurrent angular velocity: " + this.currentAngularVelocity.toString();
        ret = (String)ret + "\nCurrent angular acceleration: " + this.currentAngularAcceleration.toString();
        return ret;
    }
}

