/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories;

import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.robotics.math.trajectories.NDoFTrapezoidalVelocityTrajectory;

public abstract class FrameNDoFTrapezoidalVelocityTrajectory
implements ReferenceFrameHolder {
    private final ReferenceFrame referenceFrame;
    private final NDoFTrapezoidalVelocityTrajectory nDoFTrapezoidalVelocityTrajectory;

    public FrameNDoFTrapezoidalVelocityTrajectory(ReferenceFrame referenceFrame, double t0, double[] x0, double[] xF, double[] v0, double[] vF, double[] vMax, double[] aMax, NDoFTrapezoidalVelocityTrajectory.AlphaToAlphaType alphaToAlphaType) {
        this.referenceFrame = referenceFrame;
        this.nDoFTrapezoidalVelocityTrajectory = new NDoFTrapezoidalVelocityTrajectory(t0, x0, xF, v0, vF, vMax, aMax, alphaToAlphaType);
    }

    public void synchronize(double tFMax) {
        this.nDoFTrapezoidalVelocityTrajectory.synchronize(tFMax);
    }

    public void synchronize() {
        this.nDoFTrapezoidalVelocityTrajectory.synchronize();
    }

    public void synchronizeWith(FrameNDoFTrapezoidalVelocityTrajectory trajectory) {
        this.nDoFTrapezoidalVelocityTrajectory.synchronizeWith(trajectory.nDoFTrapezoidalVelocityTrajectory);
    }

    public double getT0() {
        return this.nDoFTrapezoidalVelocityTrajectory.getT0();
    }

    public double[] getX0Array() {
        return this.nDoFTrapezoidalVelocityTrajectory.getX0Array();
    }

    public double[] getV0Array() {
        return this.nDoFTrapezoidalVelocityTrajectory.getV0Array();
    }

    public double[] getTFArray() {
        return this.nDoFTrapezoidalVelocityTrajectory.getTFArray();
    }

    public double getTFMax() {
        return this.nDoFTrapezoidalVelocityTrajectory.getTFMax();
    }

    public double getDTFMax() {
        return this.nDoFTrapezoidalVelocityTrajectory.getDTFMax();
    }

    protected double getPosition(int index, double t) {
        return this.nDoFTrapezoidalVelocityTrajectory.getPosition(index, t);
    }

    protected double getVelocity(int index, double t) {
        return this.nDoFTrapezoidalVelocityTrajectory.getVelocity(index, t);
    }

    protected double getAcceleration(int index, double t) {
        return this.nDoFTrapezoidalVelocityTrajectory.getAcceleration(index, t);
    }

    protected double getMaximumVelocity(int index) {
        return this.nDoFTrapezoidalVelocityTrajectory.getMaximumVelocity(index);
    }

    protected double getMaximumAcceleration(int index) {
        return this.nDoFTrapezoidalVelocityTrajectory.getMaximumAcceleration(index);
    }

    protected double[] getPositionArray(double t) {
        return this.nDoFTrapezoidalVelocityTrajectory.getPositionArray(t);
    }

    protected double[] getVelocityArray(double t) {
        return this.nDoFTrapezoidalVelocityTrajectory.getVelocityArray(t);
    }

    protected double[] getAccelerationArray(double t) {
        return this.nDoFTrapezoidalVelocityTrajectory.getAccelerationArray(t);
    }

    protected double[] getMaximumVelocityArray() {
        return this.nDoFTrapezoidalVelocityTrajectory.getMaximumVelocityArray();
    }

    protected double[] getMaximumAccelerationArray() {
        return this.nDoFTrapezoidalVelocityTrajectory.getMaximumAccelerationArray();
    }

    protected int size() {
        return this.nDoFTrapezoidalVelocityTrajectory.size();
    }

    public abstract ReferenceFrameHolder getPosition(double var1);

    public abstract ReferenceFrameHolder getVelocity(double var1);

    public abstract ReferenceFrameHolder getAcceleration(double var1);

    public abstract ReferenceFrameHolder getMaximumVelocity();

    public abstract ReferenceFrameHolder getMaximumAcceleration();

    public abstract ReferenceFrameHolder getInitialPosition();

    public abstract ReferenceFrameHolder getInitialVelocity();

    public ReferenceFrame getReferenceFrame() {
        return this.referenceFrame;
    }

    public static void synchronize(FrameNDoFTrapezoidalVelocityTrajectory[] trajectories) {
        double tFMaxMax = FrameNDoFTrapezoidalVelocityTrajectory.getTFMaxMax(trajectories);
        for (FrameNDoFTrapezoidalVelocityTrajectory trajectory : trajectories) {
            trajectory.synchronize(tFMaxMax);
        }
    }

    protected static void doReferenceFrameChecks(ReferenceFrameHolder x0, ReferenceFrameHolder xF, ReferenceFrameHolder v0, ReferenceFrameHolder vF, ReferenceFrameHolder vMax, ReferenceFrameHolder aMax) {
        x0.checkReferenceFrameMatch(xF.getReferenceFrame());
        x0.checkReferenceFrameMatch(v0.getReferenceFrame());
        x0.checkReferenceFrameMatch(vF.getReferenceFrame());
        x0.checkReferenceFrameMatch(vMax.getReferenceFrame());
        x0.checkReferenceFrameMatch(aMax.getReferenceFrame());
    }

    private static double getTFMaxMax(FrameNDoFTrapezoidalVelocityTrajectory[] trajectories) {
        double tFMaxMax = Double.NEGATIVE_INFINITY;
        for (FrameNDoFTrapezoidalVelocityTrajectory trajectory : trajectories) {
            double tFMax = trajectory.getTFMax();
            if (!(tFMax > tFMaxMax)) continue;
            tFMaxMax = tFMax;
        }
        return tFMaxMax;
    }

    public String toString() {
        return "nDoFTrapezoidalVelocityTrajectory:\n" + this.nDoFTrapezoidalVelocityTrajectory.toString() + "\nreferenceFrame: " + this.referenceFrame.toString();
    }
}

