/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories;

import us.ihmc.commons.MathTools;
import us.ihmc.robotics.math.trajectories.interfaces.DoubleTrajectoryGenerator;
import us.ihmc.robotics.math.trajectories.yoVariables.YoPolynomial;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class ConstantVelocityTrajectoryGenerator
implements DoubleTrajectoryGenerator {
    private final YoRegistry registry;
    private final DoubleProvider initialPositionProvider;
    private final DoubleProvider velocityProvider;
    private final YoPolynomial polynomial;
    private final YoDouble trajectoryTime;
    private final DoubleProvider trajectoryTimeProvider;
    private final YoDouble currentTime;
    private final int numberOfCoefficients = 2;

    public ConstantVelocityTrajectoryGenerator(String namePrefix, DoubleProvider initialPositionProvider, DoubleProvider velocityProvider, DoubleProvider trajectoryTimeProvider, YoRegistry parentRegistry) {
        this.registry = new YoRegistry(namePrefix + this.getClass().getSimpleName());
        this.initialPositionProvider = initialPositionProvider;
        this.velocityProvider = velocityProvider;
        this.polynomial = new YoPolynomial(namePrefix + "Polynomial", 2, this.registry);
        this.trajectoryTime = new YoDouble(namePrefix + "TrajectoryTime", this.registry);
        this.currentTime = new YoDouble(namePrefix + "CurrentTime", this.registry);
        this.trajectoryTimeProvider = trajectoryTimeProvider;
        parentRegistry.addChild(this.registry);
    }

    @Override
    public void initialize() {
        this.currentTime.set(0.0);
        this.trajectoryTime.set(this.trajectoryTimeProvider.getValue());
        this.polynomial.setLinear(0.0, this.initialPositionProvider.getValue(), this.velocityProvider.getValue());
    }

    @Override
    public void compute(double time) {
        this.currentTime.set(time);
        time = MathTools.clamp((double)time, (double)0.0, (double)this.trajectoryTime.getDoubleValue());
        this.polynomial.compute(time);
    }

    @Override
    public boolean isDone() {
        return this.currentTime.getDoubleValue() > this.trajectoryTime.getDoubleValue();
    }

    public double getValue() {
        return this.polynomial.getValue();
    }

    @Override
    public double getVelocity() {
        return this.polynomial.getVelocity();
    }

    @Override
    public double getAcceleration() {
        return 0.0;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": x = " + this.getValue() + ", xdot = " + this.getVelocity() + "xddot = " + this.getAcceleration();
    }
}

