/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories;

import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.robotics.controllers.pidGains.GainCalculator;
import us.ihmc.robotics.linearAlgebra.MatrixExponentialCalculator;
import us.ihmc.robotics.math.trajectories.interfaces.FixedFramePositionTrajectoryGenerator;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.parameters.DoubleParameter;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class C1ContinuousTrajectorySmoother
implements FixedFramePositionTrajectoryGenerator {
    private final FixedFramePositionTrajectoryGenerator trajectoryToTrack;
    private final YoFrameVector3D positionErrorWhenStartingCancellation;
    private final YoFrameVector3D velocityErrorWhenStartingCancellation;
    private final YoFrameVector3D referencePositionError;
    private final YoFrameVector3D referenceVelocityError;
    private final YoFrameVector3D referenceAccelerationError;
    private final FramePoint3D desiredPosition;
    private final FrameVector3D desiredVelocity;
    private final FrameVector3D desiredAcceleration;
    private final YoDouble timeToStartErrorCancellation;
    private final DoubleParameter trackingStiffness;
    private final DoubleParameter trackingZeta;
    private final MatrixExponentialCalculator matrixExponentialCalculator = new MatrixExponentialCalculator(2);
    private final DMatrixRMaj closedLoopStateMatrix = new DMatrixRMaj(2, 2);
    private final DMatrixRMaj scaledClosedLoopStateMatrix = new DMatrixRMaj(2, 2);
    private final DMatrixRMaj stateTransitionMatrix = new DMatrixRMaj(2, 2);
    private boolean hasDriftDynamicsMatrixBeenSet = false;
    private boolean loaded = false;

    public C1ContinuousTrajectorySmoother(String namePrefix, FixedFramePositionTrajectoryGenerator trajectoryToTrack, YoRegistry parentRegistry) {
        this.trajectoryToTrack = trajectoryToTrack;
        YoRegistry registry = new YoRegistry(namePrefix + this.getClass().getSimpleName());
        this.trackingStiffness = new DoubleParameter(namePrefix + "TrackingStiffness", registry, 200.0);
        this.trackingZeta = new DoubleParameter(namePrefix + "TrackingZeta", registry, 0.8);
        this.trackingStiffness.addListener(v -> this.updateClosedLoopDriftDynamicsMatrix());
        this.trackingZeta.addListener(v -> this.updateClosedLoopDriftDynamicsMatrix());
        this.timeToStartErrorCancellation = new YoDouble(namePrefix + "TimeWhenStartingErrorCancellation", registry);
        this.positionErrorWhenStartingCancellation = new YoFrameVector3D(namePrefix + "PositionErrorWhenStartingCancellation", trajectoryToTrack.getReferenceFrame(), registry);
        this.velocityErrorWhenStartingCancellation = new YoFrameVector3D(namePrefix + "VelocityErrorWhenStartingCancellation", trajectoryToTrack.getReferenceFrame(), registry);
        this.referencePositionError = new YoFrameVector3D(namePrefix + "ReferencePositionError", trajectoryToTrack.getReferenceFrame(), registry);
        this.referenceVelocityError = new YoFrameVector3D(namePrefix + "ReferenceVelocityError", trajectoryToTrack.getReferenceFrame(), registry);
        this.referenceAccelerationError = new YoFrameVector3D(namePrefix + "ReferenceAccelerationError", trajectoryToTrack.getReferenceFrame(), registry);
        this.desiredPosition = new FramePoint3D(trajectoryToTrack.getReferenceFrame());
        this.desiredVelocity = new FrameVector3D(trajectoryToTrack.getReferenceFrame());
        this.desiredAcceleration = new FrameVector3D(trajectoryToTrack.getReferenceFrame());
        parentRegistry.addChild(registry);
    }

    private void updateClosedLoopDriftDynamicsMatrix() {
        if (!this.loaded) {
            return;
        }
        this.hasDriftDynamicsMatrixBeenSet = true;
        this.closedLoopStateMatrix.set(0, 1, 1.0);
        this.closedLoopStateMatrix.set(1, 0, -this.trackingStiffness.getValue());
        this.closedLoopStateMatrix.set(1, 1, -GainCalculator.computeDerivativeGain(this.trackingStiffness.getValue(), this.trackingZeta.getValue()));
    }

    public void updateErrorDynamicsAtTime(double time, FramePoint3DReadOnly desiredPositionAtTime, FrameVector3DReadOnly desiredVelocityAtTime) {
        this.trajectoryToTrack.compute(time);
        this.positionErrorWhenStartingCancellation.sub((FrameTuple3DReadOnly)desiredPositionAtTime, (FrameTuple3DReadOnly)this.trajectoryToTrack.getPosition());
        this.velocityErrorWhenStartingCancellation.sub((FrameTuple3DReadOnly)desiredVelocityAtTime, (FrameTuple3DReadOnly)this.trajectoryToTrack.getVelocity());
        this.timeToStartErrorCancellation.set(time);
    }

    @Override
    public void initialize() {
        this.positionErrorWhenStartingCancellation.setToZero();
        this.velocityErrorWhenStartingCancellation.setToZero();
        this.timeToStartErrorCancellation.set(0.0);
    }

    @Override
    public void compute(double time) {
        if (!this.loaded) {
            this.loaded = true;
        }
        if (!this.hasDriftDynamicsMatrixBeenSet) {
            this.updateClosedLoopDriftDynamicsMatrix();
        }
        double relativeTime = time - this.timeToStartErrorCancellation.getDoubleValue();
        CommonOps_DDRM.scale((double)relativeTime, (DMatrixD1)this.closedLoopStateMatrix, (DMatrixD1)this.scaledClosedLoopStateMatrix);
        this.matrixExponentialCalculator.compute(this.stateTransitionMatrix, this.scaledClosedLoopStateMatrix);
        double dampingGain = GainCalculator.computeDerivativeGain(this.trackingStiffness.getValue(), this.trackingZeta.getValue());
        for (int element = 0; element < 3; ++element) {
            double position = this.stateTransitionMatrix.get(0, 0) * this.positionErrorWhenStartingCancellation.getElement(element) + this.stateTransitionMatrix.get(0, 1) * this.velocityErrorWhenStartingCancellation.getElement(element);
            double velocity = this.stateTransitionMatrix.get(1, 0) * this.positionErrorWhenStartingCancellation.getElement(element) + this.stateTransitionMatrix.get(1, 1) * this.velocityErrorWhenStartingCancellation.getElement(element);
            this.referencePositionError.setElement(element, position);
            this.referenceVelocityError.setElement(element, velocity);
            this.referenceAccelerationError.setElement(element, -this.trackingStiffness.getValue() * position - dampingGain * velocity);
        }
        this.trajectoryToTrack.compute(time);
        this.desiredPosition.add((FrameTuple3DReadOnly)this.trajectoryToTrack.getPosition(), (FrameTuple3DReadOnly)this.referencePositionError);
        this.desiredVelocity.add((FrameTuple3DReadOnly)this.trajectoryToTrack.getVelocity(), (FrameTuple3DReadOnly)this.referenceVelocityError);
        this.desiredAcceleration.add((FrameTuple3DReadOnly)this.trajectoryToTrack.getAcceleration(), (FrameTuple3DReadOnly)this.referenceAccelerationError);
    }

    @Override
    public boolean isDone() {
        return this.trajectoryToTrack.isDone();
    }

    @Override
    public FramePoint3DReadOnly getPosition() {
        return this.desiredPosition;
    }

    @Override
    public FrameVector3DReadOnly getVelocity() {
        return this.desiredVelocity;
    }

    @Override
    public FrameVector3DReadOnly getAcceleration() {
        return this.desiredAcceleration;
    }

    @Override
    public void showVisualization() {
    }

    @Override
    public void hideVisualization() {
    }

    FrameVector3DReadOnly getPositionErrorWhenStartingCancellation() {
        return this.positionErrorWhenStartingCancellation;
    }

    FrameVector3DReadOnly getVelocityErrorWhenStartingCancellation() {
        return this.velocityErrorWhenStartingCancellation;
    }

    FrameVector3DReadOnly getReferencePositionError() {
        return this.referencePositionError;
    }

    FrameVector3DReadOnly getReferenceVelocityError() {
        return this.referenceVelocityError;
    }
}

