/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.functionGenerator;

import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.robotics.math.functionGenerator.BaseFunctionGenerator;

public class SawtoothWaveFunctionGenerator
extends BaseFunctionGenerator {
    @Override
    protected double computeValue() {
        double alpha = this.getAngle() / (Math.PI * 2);
        double amplitude = this.getAmplitude();
        double offset = this.getOffset();
        return offset + EuclidCoreTools.interpolate((double)(-amplitude), (double)amplitude, (double)alpha);
    }

    @Override
    protected double computeValueDot() {
        double amplitude = this.getAmplitude();
        double frequency = this.getFrequency();
        return 2.0 * amplitude * frequency;
    }

    @Override
    protected double computeValueDDot() {
        return 0.0;
    }
}

