/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.functionGenerator;

import gnu.trove.list.array.TDoubleArrayList;
import java.util.ArrayList;
import java.util.List;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.robotics.math.functionGenerator.YoFunctionGeneratorNew;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;
import us.ihmc.yoVariables.variable.YoLong;

public class FunctionGeneratorErrorCalculator {
    private static final int SAMPLES_PER_PERIOD = 100;
    private final double controlDT;
    private final YoLong controllerCounter;
    private final YoRegistry registry;
    private final List<TrajectorySignal> trajectorySignals = new ArrayList<TrajectorySignal>();

    public FunctionGeneratorErrorCalculator(String namePrefix, double controlDT, YoRegistry registry) {
        this.registry = registry;
        this.controlDT = controlDT;
        this.controllerCounter = new YoLong(namePrefix + "controllerCounter", registry);
    }

    public void addTrajectorySignal(YoFunctionGeneratorNew functionGenerator, OneDoFJointBasics joint) {
        this.trajectorySignals.add(new TrajectorySignal(functionGenerator, joint, this.registry));
    }

    public void update() {
        this.controllerCounter.increment();
        for (int i = 0; i < this.trajectorySignals.size(); ++i) {
            this.trajectorySignals.get(i).update();
        }
    }

    private class TrajectorySignal {
        private final YoFunctionGeneratorNew functionGenerator;
        private final OneDoFJointBasics joint;
        private final YoDouble previousFrequency;
        private final YoInteger controlTicksPerSample;
        private final YoLong startCount;
        private final YoInteger counter;
        private final YoDouble rmsPositionError;
        private final YoDouble rmsVelocityError;
        private final TDoubleArrayList positionErrorsSq = new TDoubleArrayList(new double[100]);
        private final TDoubleArrayList velocityErrorsSq = new TDoubleArrayList(new double[100]);
        private boolean firstTick = true;

        TrajectorySignal(YoFunctionGeneratorNew functionGenerator, OneDoFJointBasics joint, YoRegistry registry) {
            this.functionGenerator = functionGenerator;
            this.joint = joint;
            this.previousFrequency = new YoDouble("prevFreq" + joint.getName(), registry);
            this.controlTicksPerSample = new YoInteger("sampleFreq" + joint.getName(), registry);
            this.rmsPositionError = new YoDouble("q_err_rms_" + joint.getName(), registry);
            this.rmsVelocityError = new YoDouble("qd_err_rms_" + joint.getName(), registry);
            this.startCount = new YoLong("startCount" + joint.getName(), registry);
            this.counter = new YoInteger("counter" + joint.getName(), registry);
        }

        void update() {
            if (this.firstTick || !EuclidCoreTools.epsilonEquals((double)this.functionGenerator.getFrequency(), (double)this.previousFrequency.getValue(), (double)1.0E-5)) {
                this.firstTick = false;
                this.previousFrequency.set(this.functionGenerator.getFrequency());
                double periodDuration = 1.0 / this.functionGenerator.getFrequency();
                double sampleDT = periodDuration / 100.0;
                this.controlTicksPerSample.set(Math.max((int)(sampleDT / FunctionGeneratorErrorCalculator.this.controlDT), 1));
                this.positionErrorsSq.fill(0.0);
                this.velocityErrorsSq.fill(0.0);
                this.startCount.set(FunctionGeneratorErrorCalculator.this.controllerCounter.getValue());
                this.counter.set(0);
                this.firstTick = false;
            }
            long count = FunctionGeneratorErrorCalculator.this.controllerCounter.getValue() - this.startCount.getValue();
            if (this.controlTicksPerSample.getValue() > 0 && count % (long)this.controlTicksPerSample.getValue() == 0L) {
                this.positionErrorsSq.set(this.counter.getValue(), EuclidCoreTools.square((double)(this.functionGenerator.getValue() - this.joint.getQ())));
                this.velocityErrorsSq.set(this.counter.getValue(), EuclidCoreTools.square((double)(this.functionGenerator.getValueDot() - this.joint.getQd())));
                this.rmsPositionError.set(Math.sqrt(this.positionErrorsSq.sum() / 100.0));
                this.rmsVelocityError.set(Math.sqrt(this.velocityErrorsSq.sum() / 100.0));
                this.counter.set((this.counter.getValue() + 1) % 100);
            }
        }
    }
}

