/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.functionGenerator;

import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.robotics.math.functionGenerator.BaseFunctionGenerator;
import us.ihmc.robotics.math.functionGenerator.SineWaveFunctionGenerator;
import us.ihmc.robotics.math.functionGenerator.TriangleWaveFunctionGenerator;
import us.ihmc.yoVariables.providers.DoubleProvider;

public class ChirpLinearFunctionGenerator {
    private DoubleProvider lowFrequency = BaseFunctionGenerator.zeroDoubleProvider;
    private DoubleProvider highFrequency = BaseFunctionGenerator.zeroDoubleProvider;
    private DoubleProvider chirpDuration = BaseFunctionGenerator.zeroDoubleProvider;
    private final DoubleProvider frequencyProvider;
    private final TriangleWaveFunctionGenerator frequencyFunction = new TriangleWaveFunctionGenerator();
    private BaseFunctionGenerator baseFunction = new SineWaveFunctionGenerator();

    public ChirpLinearFunctionGenerator() {
        this.frequencyFunction.setOffset(() -> 0.5);
        this.frequencyFunction.setAmplitude(() -> 0.5);
        this.frequencyFunction.setFrequency(() -> 0.5 / this.chirpDuration.getValue());
        this.frequencyProvider = () -> EuclidCoreTools.interpolate((double)this.lowFrequency.getValue(), (double)this.highFrequency.getValue(), (double)this.frequencyFunction.getValue());
        this.setBaseFunction(new SineWaveFunctionGenerator());
    }

    public void setBaseFunction(BaseFunctionGenerator baseFunction) {
        this.baseFunction = baseFunction;
    }

    public DoubleProvider getFrequencyProvider() {
        return this.frequencyProvider;
    }

    private void markDirty() {
        this.frequencyFunction.markDirty();
        this.baseFunction.markDirty();
    }

    public void resetChirp() {
        this.frequencyFunction.resetAngle();
        this.baseFunction.setFrequency(this.frequencyProvider);
        this.baseFunction.resetAngle();
    }

    public void integrateAngle(double dt) {
        this.frequencyFunction.integrateAngle(dt);
        this.baseFunction.setFrequency(this.frequencyProvider);
        this.baseFunction.integrateAngle(dt);
    }

    public void setAngle(double angle) {
        this.baseFunction.setAngle(angle);
    }

    public void setOffset(double offset) {
        this.setOffset(() -> offset);
    }

    public void setOffset(DoubleProvider offset) {
        this.baseFunction.setOffset(offset);
    }

    public void setAmplitude(double amplitude) {
        this.setAmplitude(() -> amplitude);
    }

    public void setAmplitude(DoubleProvider amplitude) {
        this.baseFunction.setAmplitude(amplitude);
    }

    public void setLowFrequency(double lowFrequency) {
        this.setLowFrequency(() -> lowFrequency);
    }

    public void setLowFrequency(DoubleProvider lowFrequency) {
        this.lowFrequency = lowFrequency;
        this.markDirty();
    }

    public void setHighFrequency(double highFrequency) {
        this.setHighFrequency(() -> highFrequency);
    }

    public void setHighFrequency(DoubleProvider highFrequency) {
        this.highFrequency = highFrequency;
        this.markDirty();
    }

    public void setChirpDuration(double chirpDuration) {
        this.setChirpDuration(() -> chirpDuration);
    }

    public void setChirpDuration(DoubleProvider chirpDuration) {
        this.chirpDuration = chirpDuration;
        this.markDirty();
    }

    public void setPhase(double phase) {
        this.setPhase(() -> phase);
    }

    public void setPhase(DoubleProvider phase) {
        this.baseFunction.setPhase(phase);
    }

    public double getOffset() {
        return this.baseFunction.getOffset();
    }

    public double getAmplitude() {
        return this.baseFunction.getAmplitude();
    }

    public double getFrequency() {
        return this.baseFunction.getFrequency();
    }

    public double getLowFrequency() {
        return this.lowFrequency.getValue();
    }

    public double getHighFrequency() {
        return this.highFrequency.getValue();
    }

    public double getChirpDuration() {
        return this.chirpDuration.getValue();
    }

    public double getPhase() {
        return this.baseFunction.getPhase();
    }

    public double getAngle() {
        return this.baseFunction.getAngle();
    }

    public double getAngleDot() {
        return this.baseFunction.getAngleDot();
    }

    public double getValue() {
        return this.baseFunction.getValue();
    }

    public double getValueDot() {
        return this.baseFunction.getValueDot();
    }

    public double getValueDDot() {
        return this.baseFunction.getValueDDot();
    }
}

