/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.filters;

import us.ihmc.robotics.linearDynamicSystems.LinearDynamicSystem;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class YoLinearDynamicSystem {
    private final LinearDynamicSystem linearDynamicSystem;
    private final YoDouble[] stateVariables;
    private final YoDouble[] inputVariables;
    private final YoDouble[] outputVariables;

    public YoLinearDynamicSystem(LinearDynamicSystem linearDynamicSystem, String statePrefix, String inputPrefix, String outputPrefix, YoRegistry registry) {
        int i;
        this.linearDynamicSystem = linearDynamicSystem;
        int order = linearDynamicSystem.getOrder();
        int inputSize = linearDynamicSystem.getInputSize();
        int outputSize = linearDynamicSystem.getOutputSize();
        this.stateVariables = new YoDouble[order];
        this.inputVariables = new YoDouble[inputSize];
        this.outputVariables = new YoDouble[outputSize];
        for (i = 0; i < order; ++i) {
            this.stateVariables[i] = new YoDouble(statePrefix + i, registry);
        }
        for (i = 0; i < inputSize; ++i) {
            this.inputVariables[i] = new YoDouble(inputPrefix + i, registry);
        }
        for (i = 0; i < outputSize; ++i) {
            this.outputVariables[i] = new YoDouble(outputPrefix + i, registry);
        }
    }

    public YoDouble[] getStateVariables() {
        return this.stateVariables;
    }

    public YoDouble[] getInputVariables() {
        return this.inputVariables;
    }

    public YoDouble[] getOuptutVariables() {
        return this.outputVariables;
    }

    public void update(double[] input, double dt) {
        double[] currentState = this.getState();
        YoLinearDynamicSystem.setVariables(this.inputVariables, input);
        double[] nextState = this.linearDynamicSystem.eulerIntegrateOneStep(currentState, input, dt);
        this.setState(nextState);
        double[] output = this.linearDynamicSystem.getOutputFromState(nextState, input);
        YoLinearDynamicSystem.setVariables(this.outputVariables, output);
    }

    public void setState(double[] state) {
        YoLinearDynamicSystem.setVariables(this.stateVariables, state);
    }

    private static void setVariables(YoDouble[] variables, double[] values) {
        if (variables.length != values.length) {
            throw new RuntimeException("variables.length != values.length");
        }
        for (int i = 0; i < variables.length; ++i) {
            variables[i].set(values[i]);
        }
    }

    private static double[] getVariables(YoDouble[] variables) {
        double[] values = new double[variables.length];
        for (int i = 0; i < variables.length; ++i) {
            values[i] = variables[i].getValue();
        }
        return values;
    }

    public double[] getState() {
        return YoLinearDynamicSystem.getVariables(this.stateVariables);
    }

    public double[] getOutput() {
        return YoLinearDynamicSystem.getVariables(this.outputVariables);
    }

    public double[] getInput() {
        return YoLinearDynamicSystem.getVariables(this.inputVariables);
    }
}

