/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.filters;

import us.ihmc.commons.MathTools;
import us.ihmc.robotics.math.filters.FilteredVelocityYoVariable;
import us.ihmc.robotics.math.filters.ProcessingYoVariable;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoEnum;

public class RevisedBacklashCompensatingVelocityYoVariable
extends YoDouble
implements ProcessingYoVariable {
    private final double dt;
    private final FilteredVelocityYoVariable finiteDifferenceVelocity;
    private final DoubleProvider alphaVariable;
    private final YoDouble position;
    private final YoDouble lastPosition;
    private final YoBoolean hasBeenCalled;
    private final YoEnum<BacklashState> backlashState;
    private final DoubleProvider slopTime;
    private final YoDouble timeSinceSloppy;

    public RevisedBacklashCompensatingVelocityYoVariable(String name, String description, DoubleProvider alphaVariable, YoDouble positionVariable, double dt, DoubleProvider slopTime, YoRegistry registry) {
        super(name, description, registry);
        this.finiteDifferenceVelocity = new FilteredVelocityYoVariable(name + "finiteDifferenceVelocity", "", alphaVariable, dt, registry);
        this.hasBeenCalled = new YoBoolean(name + "HasBeenCalled", registry);
        this.backlashState = new YoEnum(name + "BacklashState", registry, BacklashState.class, true);
        this.backlashState.set(null);
        this.timeSinceSloppy = new YoDouble(name + "TimeSinceSloppy", registry);
        this.position = positionVariable;
        this.alphaVariable = alphaVariable;
        this.slopTime = slopTime;
        this.dt = dt;
        this.lastPosition = new YoDouble(name + "_lastPosition", registry);
        this.reset();
    }

    public RevisedBacklashCompensatingVelocityYoVariable(String name, String description, YoDouble alphaVariable, double dt, YoDouble slopTime, YoRegistry registry) {
        super(name, description, registry);
        this.finiteDifferenceVelocity = new FilteredVelocityYoVariable(name + "finiteDifferenceVelocity", "", (DoubleProvider)alphaVariable, dt, registry);
        this.hasBeenCalled = new YoBoolean(name + "HasBeenCalled", registry);
        this.backlashState = new YoEnum(name + "BacklashState", registry, BacklashState.class, true);
        this.backlashState.set(null);
        this.timeSinceSloppy = new YoDouble(name + "timeInState", registry);
        this.position = null;
        this.alphaVariable = alphaVariable;
        this.slopTime = slopTime;
        this.dt = dt;
        this.lastPosition = new YoDouble(name + "_lastPosition", registry);
        this.reset();
    }

    @Override
    public void reset() {
        this.hasBeenCalled.set(false);
        this.backlashState.set(null);
    }

    @Override
    public void update() {
        if (this.position == null) {
            throw new NullPointerException("YoFilteredVelocityVariable must be constructed with a non null position variable to call update(), otherwise use update(double)");
        }
        this.update(this.position.getDoubleValue());
    }

    public void update(double currentPosition) {
        if (this.backlashState.getEnumValue() == null) {
            this.backlashState.set((Enum)BacklashState.FORWARD_OK);
        }
        this.finiteDifferenceVelocity.update(currentPosition);
        if (!this.hasBeenCalled.getBooleanValue()) {
            this.hasBeenCalled.set(true);
            this.lastPosition.set(currentPosition);
            this.set(0.0);
        }
        this.timeSinceSloppy.add(this.dt);
        double velocityFromFiniteDifferences = this.finiteDifferenceVelocity.getDoubleValue();
        switch ((BacklashState)this.backlashState.getEnumValue()) {
            case BACKWARD_OK: {
                if (!(velocityFromFiniteDifferences > 0.0)) break;
                this.timeSinceSloppy.set(0.0);
                this.backlashState.set((Enum)BacklashState.FORWARD_SLOP);
                break;
            }
            case FORWARD_OK: {
                if (!(velocityFromFiniteDifferences < 0.0)) break;
                this.timeSinceSloppy.set(0.0);
                this.backlashState.set((Enum)BacklashState.BACKWARD_SLOP);
                break;
            }
            case BACKWARD_SLOP: {
                if (velocityFromFiniteDifferences > 0.0) {
                    this.timeSinceSloppy.set(0.0);
                    this.backlashState.set((Enum)BacklashState.FORWARD_SLOP);
                    break;
                }
                if (!(this.timeSinceSloppy.getDoubleValue() > this.slopTime.getValue())) break;
                this.backlashState.set((Enum)BacklashState.BACKWARD_OK);
                break;
            }
            case FORWARD_SLOP: {
                if (velocityFromFiniteDifferences < 0.0) {
                    this.timeSinceSloppy.set(0.0);
                    this.backlashState.set((Enum)BacklashState.BACKWARD_SLOP);
                    break;
                }
                if (!(this.timeSinceSloppy.getDoubleValue() > this.slopTime.getValue())) break;
                this.backlashState.set((Enum)BacklashState.FORWARD_OK);
            }
        }
        double difference = currentPosition - this.lastPosition.getDoubleValue();
        double percent = this.timeSinceSloppy.getDoubleValue() / this.slopTime.getValue();
        percent = MathTools.clamp((double)percent, (double)0.0, (double)1.0);
        if (Double.isNaN(percent)) {
            percent = 1.0;
        }
        double scaleFactor = percent;
        difference = scaleFactor * difference;
        this.updateUsingDifference(difference);
        this.lastPosition.set(currentPosition);
    }

    private void updateUsingDifference(double difference) {
        double previousFilteredDerivative = this.getDoubleValue();
        double currentRawDerivative = difference / this.dt;
        double alpha = this.alphaVariable.getValue();
        this.set(alpha * previousFilteredDerivative + (1.0 - alpha) * currentRawDerivative);
    }

    private static enum BacklashState {
        BACKWARD_OK,
        FORWARD_OK,
        BACKWARD_SLOP,
        FORWARD_SLOP;

    }
}

