/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.filters;

import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Tuple4DReadOnly;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameQuaternion;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class RateLimitedYoFrameQuaternion
extends YoFrameQuaternion {
    private final QuaternionReadOnly rawQuaternion;
    private final YoBoolean hasBeenCalled;
    private final double dt;
    private final YoBoolean limited;
    private final DoubleProvider maxRateVariable;
    private final Quaternion quaternion = new Quaternion();
    private final Quaternion difference = new Quaternion();
    private final Vector3D limitedRotationVector = new Vector3D();

    private static DoubleProvider createMaxRateYoDouble(String namePrefix, String nameSuffix, double initialValue, YoRegistry registry) {
        YoDouble maxRate = new YoDouble(namePrefix + "MaxRate" + nameSuffix, registry);
        maxRate.set(initialValue);
        return maxRate;
    }

    public RateLimitedYoFrameQuaternion(String namePrefix, String nameSuffix, YoRegistry registry, double maxRate, double dt, FrameQuaternionReadOnly rawQuaternion) {
        this(namePrefix, nameSuffix, registry, RateLimitedYoFrameQuaternion.createMaxRateYoDouble(namePrefix, nameSuffix, maxRate, registry), dt, rawQuaternion.getReferenceFrame(), (QuaternionReadOnly)rawQuaternion);
    }

    public RateLimitedYoFrameQuaternion(String namePrefix, String nameSuffix, YoRegistry registry, double maxRate, double dt, ReferenceFrame referenceFrame) {
        this(namePrefix, nameSuffix, registry, RateLimitedYoFrameQuaternion.createMaxRateYoDouble(namePrefix, nameSuffix, maxRate, registry), dt, referenceFrame, null);
    }

    public RateLimitedYoFrameQuaternion(String namePrefix, String nameSuffix, YoRegistry registry, double maxRate, double dt, ReferenceFrame referenceFrame, QuaternionReadOnly rawQuaternion) {
        this(namePrefix, nameSuffix, registry, RateLimitedYoFrameQuaternion.createMaxRateYoDouble(namePrefix, nameSuffix, maxRate, registry), dt, referenceFrame, rawQuaternion);
    }

    public RateLimitedYoFrameQuaternion(String namePrefix, String nameSuffix, YoRegistry registry, DoubleProvider maxRate, double dt, FrameQuaternionReadOnly rawQuaternion) {
        this(namePrefix, nameSuffix, registry, maxRate, dt, rawQuaternion.getReferenceFrame(), (QuaternionReadOnly)rawQuaternion);
    }

    public RateLimitedYoFrameQuaternion(String namePrefix, String nameSuffix, YoRegistry registry, DoubleProvider maxRate, double dt, ReferenceFrame referenceFrame) {
        this(namePrefix, nameSuffix, registry, maxRate, dt, referenceFrame, null);
    }

    public RateLimitedYoFrameQuaternion(String namePrefix, String nameSuffix, YoRegistry registry, DoubleProvider maxRate, double dt, ReferenceFrame referenceFrame, QuaternionReadOnly rawQuaternion) {
        super(namePrefix, nameSuffix, referenceFrame, registry);
        this.hasBeenCalled = new YoBoolean(namePrefix + "HasBeenCalled" + nameSuffix, registry);
        this.limited = new YoBoolean(namePrefix + "Limited" + nameSuffix, registry);
        if (maxRate == null) {
            maxRate = RateLimitedYoFrameQuaternion.createMaxRateYoDouble(namePrefix, nameSuffix, Double.POSITIVE_INFINITY, registry);
        }
        this.maxRateVariable = maxRate;
        this.rawQuaternion = rawQuaternion;
        this.dt = dt;
        this.reset();
    }

    public void reset() {
        this.hasBeenCalled.set(false);
    }

    public void update() {
        if (this.rawQuaternion == null) {
            throw new NullPointerException(((Object)((Object)this)).getClass().getSimpleName() + " must be constructed with a non null position variable to call update(), otherwise use update(double)");
        }
        this.update(this.rawQuaternion);
    }

    public void update(FrameOrientation3DReadOnly frameOrientationUnfiltered) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)frameOrientationUnfiltered);
        this.quaternion.set((Orientation3DReadOnly)frameOrientationUnfiltered);
        this.update((QuaternionReadOnly)this.quaternion);
    }

    public void update(FrameQuaternionReadOnly frameQuaternionUnfiltered) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)frameQuaternionUnfiltered);
        this.quaternion.set((QuaternionReadOnly)frameQuaternionUnfiltered);
        this.update((QuaternionReadOnly)this.quaternion);
    }

    public void update(QuaternionReadOnly quaternionUnfiltered) {
        if (!this.hasBeenCalled.getBooleanValue() || this.containsNaN()) {
            this.hasBeenCalled.set(true);
            this.limited.set(false);
            this.set(quaternionUnfiltered);
            return;
        }
        if (this.dot((Tuple4DReadOnly)quaternionUnfiltered) > 0.0) {
            this.difference.difference((QuaternionReadOnly)this, quaternionUnfiltered);
        } else {
            this.difference.setAndNegate(quaternionUnfiltered);
            this.difference.preMultiplyConjugateOther((QuaternionReadOnly)this);
        }
        this.difference.getRotationVector((Vector3DBasics)this.limitedRotationVector);
        boolean clipped = this.limitedRotationVector.clipToMaxLength(this.dt * this.maxRateVariable.getValue());
        this.limited.set(clipped);
        if (clipped) {
            this.difference.setRotationVector((Vector3DReadOnly)this.limitedRotationVector);
            this.multiply((QuaternionReadOnly)this.difference);
        } else {
            this.set(quaternionUnfiltered);
        }
    }
}

