/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.filters;

import us.ihmc.euclid.referenceFrame.FrameVector2D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint2D;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class RateLimitedYoFramePoint2D
extends YoFramePoint2D {
    private final DoubleProvider maxRateVariable;
    private final FrameTuple2DReadOnly rawPosition;
    private final YoBoolean limited;
    private final YoBoolean hasBeenCalled;
    private final double dt;
    private final FrameVector2D differenceVector = new FrameVector2D();

    private static DoubleProvider createMaxRateYoDouble(String namePrefix, String nameSuffix, double initialValue, YoRegistry registry) {
        YoDouble maxRate = new YoDouble(namePrefix + "MaxRate" + nameSuffix, registry);
        maxRate.set(initialValue);
        return maxRate;
    }

    public RateLimitedYoFramePoint2D(String namePrefix, String nameSuffix, YoRegistry registry, DoubleProvider maxRate, double dt, FrameTuple2DReadOnly rawPosition) {
        this(namePrefix, nameSuffix, registry, maxRate, dt, rawPosition, rawPosition.getReferenceFrame());
    }

    public RateLimitedYoFramePoint2D(String namePrefix, String nameSuffix, YoRegistry registry, DoubleProvider maxRate, double dt, ReferenceFrame referenceFrame) {
        this(namePrefix, nameSuffix, registry, maxRate, dt, null, referenceFrame);
    }

    public RateLimitedYoFramePoint2D(String namePrefix, String nameSuffix, YoRegistry registry, double maxRate, double dt, FrameTuple2DReadOnly rawPosition) {
        this(namePrefix, nameSuffix, registry, RateLimitedYoFramePoint2D.createMaxRateYoDouble(namePrefix, nameSuffix, maxRate, registry), dt, rawPosition, rawPosition.getReferenceFrame());
    }

    public RateLimitedYoFramePoint2D(String namePrefix, String nameSuffix, YoRegistry registry, double maxRate, double dt, ReferenceFrame referenceFrame) {
        this(namePrefix, nameSuffix, registry, RateLimitedYoFramePoint2D.createMaxRateYoDouble(namePrefix, nameSuffix, maxRate, registry), dt, null, referenceFrame);
    }

    private RateLimitedYoFramePoint2D(String namePrefix, String nameSuffix, YoRegistry registry, DoubleProvider maxRate, double dt, FrameTuple2DReadOnly rawPosition, ReferenceFrame referenceFrame) {
        super(namePrefix, nameSuffix, referenceFrame, registry);
        this.hasBeenCalled = new YoBoolean(namePrefix + "HasBeenCalled" + nameSuffix, registry);
        this.limited = new YoBoolean(namePrefix + "Limited" + nameSuffix, registry);
        if (maxRate == null) {
            maxRate = RateLimitedYoFramePoint2D.createMaxRateYoDouble(namePrefix, nameSuffix, Double.POSITIVE_INFINITY, registry);
        }
        this.maxRateVariable = maxRate;
        this.rawPosition = rawPosition;
        this.dt = dt;
        this.reset();
    }

    public void setAndUpdate(FramePoint2DReadOnly framePoint2D) {
        super.set((FrameTuple2DReadOnly)framePoint2D);
        this.hasBeenCalled.set(true);
    }

    public void setAndUpdate(FramePoint3DReadOnly framePoint3D) {
        super.set((FrameTuple3DReadOnly)framePoint3D);
        this.hasBeenCalled.set(true);
    }

    public void reset() {
        this.hasBeenCalled.set(false);
    }

    public void update() {
        if (this.rawPosition == null) {
            throw new NullPointerException(((Object)((Object)this)).getClass().getSimpleName() + " must be constructed with a non null position variable to call update(), otherwise use update(double)");
        }
        this.update(this.rawPosition);
    }

    public void update(FrameTuple2DReadOnly frameVectorUnfiltered) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)frameVectorUnfiltered);
        this.update(frameVectorUnfiltered.getX(), frameVectorUnfiltered.getY());
    }

    public void update(Tuple2DReadOnly vectorUnfiltered) {
        this.update(vectorUnfiltered.getX(), vectorUnfiltered.getY());
    }

    public void update(double xUnfiltered, double yUnfiltered) {
        if (!this.hasBeenCalled.getBooleanValue() || this.containsNaN()) {
            this.hasBeenCalled.set(true);
            this.set(xUnfiltered, yUnfiltered);
        }
        if (this.maxRateVariable.getValue() < 0.0) {
            throw new RuntimeException("The maxRate parameter in the " + ((Object)((Object)this)).getClass().getSimpleName() + " cannot be negative.");
        }
        this.differenceVector.setToZero(this.getReferenceFrame());
        this.differenceVector.set(xUnfiltered, yUnfiltered);
        this.differenceVector.sub(this.getX(), this.getY());
        this.limited.set(this.differenceVector.clipToMaxLength(this.maxRateVariable.getValue() * this.dt));
        this.add((FrameTuple2DReadOnly)this.differenceVector);
    }
}

