/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.filters;

import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class HysteresisFilteredYoVariable
extends YoDouble {
    private YoDouble hysteresisAmount;
    private double previousUnfilteredValue;
    private double upperLimit;
    private double lowerLimit;

    public HysteresisFilteredYoVariable(String name, YoRegistry registry, YoDouble hysteresisAmount) {
        super(name, registry);
        this.hysteresisAmount = hysteresisAmount;
        this.set(Double.NaN);
    }

    public void reset() {
        this.rangeCheck(this.hysteresisAmount.getDoubleValue());
        super.set(this.previousUnfilteredValue);
        this.upperLimit = this.getDoubleValue() + this.hysteresisAmount.getDoubleValue() / 2.0;
        this.lowerLimit = this.getDoubleValue() - this.hysteresisAmount.getDoubleValue() / 2.0;
    }

    public void update(double unfilteredValue) {
        this.rangeCheck(this.hysteresisAmount.getDoubleValue());
        this.previousUnfilteredValue = unfilteredValue;
        if (Double.isNaN(this.getDoubleValue())) {
            super.set(unfilteredValue);
            this.upperLimit = this.getDoubleValue() + this.hysteresisAmount.getDoubleValue() / 2.0;
            this.lowerLimit = this.getDoubleValue() - this.hysteresisAmount.getDoubleValue() / 2.0;
        } else {
            boolean exceededLower;
            boolean exceededUpper = unfilteredValue > this.upperLimit;
            boolean bl = exceededLower = unfilteredValue < this.lowerLimit;
            if (exceededUpper) {
                this.upperLimit = unfilteredValue;
                this.lowerLimit = this.upperLimit - this.hysteresisAmount.getDoubleValue();
                super.set((this.upperLimit + this.lowerLimit) / 2.0);
            } else if (exceededLower) {
                this.lowerLimit = unfilteredValue;
                this.upperLimit = this.lowerLimit + this.hysteresisAmount.getDoubleValue();
                super.set((this.upperLimit + this.lowerLimit) / 2.0);
            }
        }
    }

    private void rangeCheck(double hysteresisAmount) {
        if (Double.isNaN(hysteresisAmount)) {
            throw new RuntimeException("hysteresisAmount is NaN");
        }
        if (hysteresisAmount < 0.0) {
            throw new RuntimeException("hysteresisAmount is negative");
        }
    }

    public static void main(String[] args) {
        YoRegistry registry = new YoRegistry("test");
        YoDouble hysteresisAmount = new YoDouble("hysteresisAmount", registry);
        new HysteresisFilteredYoVariable("test", registry, hysteresisAmount);
        System.out.println("done");
    }
}

