/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.filters;

import us.ihmc.yoVariables.providers.IntegerProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoInteger;

public class GlitchFilteredYoInteger
extends YoInteger {
    private final YoInteger position;
    private final YoInteger previousPosition;
    private final IntegerProvider windowSize;
    private final YoInteger counter;

    public GlitchFilteredYoInteger(String name, int windowSize, YoRegistry registry) {
        this(name, windowSize, null, registry);
    }

    public GlitchFilteredYoInteger(String name, int windowSize, YoInteger position, YoRegistry registry) {
        super(name, GlitchFilteredYoInteger.class.getSimpleName(), registry);
        this.position = position;
        this.previousPosition = new YoInteger(name + "PrevValue", registry);
        this.counter = new YoInteger(name + "Count", registry);
        YoInteger yoWindowSize = new YoInteger(name + "WindowSize", registry);
        yoWindowSize.set(windowSize);
        this.windowSize = yoWindowSize;
    }

    public GlitchFilteredYoInteger(String name, IntegerProvider windowSize, YoRegistry registry) {
        this(name, windowSize, null, registry);
    }

    public GlitchFilteredYoInteger(String name, IntegerProvider windowSize, YoInteger position, YoRegistry registry) {
        super(name, GlitchFilteredYoInteger.class.getSimpleName(), registry);
        this.position = position;
        this.previousPosition = new YoInteger(name + "PrevValue", registry);
        this.counter = new YoInteger(name + "Count", registry);
        this.windowSize = windowSize;
    }

    public boolean set(int value) {
        if (this.counter != null) {
            this.counter.set(0);
        }
        return super.set(value);
    }

    public boolean set(int value, boolean notifyListeners) {
        if (this.counter != null) {
            this.counter.set(0);
        }
        return super.set(value, notifyListeners);
    }

    public void update() {
        if (this.position == null) {
            throw new NullPointerException("GlitchFilteredYoInteger must be constructed with a non null position variable to call update(), otherwise use update(int)");
        }
        this.update(this.position.getIntegerValue());
    }

    public void update(int currentValue) {
        if (currentValue == this.previousPosition.getIntegerValue()) {
            this.counter.increment();
        } else {
            this.counter.set(0);
        }
        if (this.counter.getIntegerValue() >= this.windowSize.getValue()) {
            this.set(currentValue);
            this.counter.set(0);
        }
        this.previousPosition.set(currentValue);
    }

    public int getWindowSize() {
        return this.windowSize.getValue();
    }

    public void setWindowSize(int windowSize) {
        if (!(this.windowSize instanceof YoInteger)) {
            throw new RuntimeException("Setting the window size is not supported");
        }
        ((YoInteger)this.windowSize).set(windowSize);
    }
}

