/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.filters;

import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoInteger;

public class GlitchFilteredYoBoolean
extends YoBoolean {
    private YoBoolean variableToFilter;
    private final YoInteger windowSize;
    protected final YoInteger counter;

    public GlitchFilteredYoBoolean(String name, int windowSize) {
        super(name, "GlitchFilteredYoBoolean", null);
        this.counter = new YoInteger(name + "Count", this.getRegistry());
        this.windowSize = new YoInteger(name + "WindowSize", this.getRegistry());
        this.initialize(null, windowSize);
    }

    public GlitchFilteredYoBoolean(String name, YoRegistry registry, int windowSize) {
        super(name, registry);
        this.counter = new YoInteger(name + "Count", registry);
        this.windowSize = new YoInteger(name + "WindowSize", registry);
        this.initialize(null, windowSize);
    }

    public GlitchFilteredYoBoolean(String name, YoBoolean yoVariableToFilter, int windowSize) {
        super(name, "GlitchFilteredYoBoolean", null);
        this.counter = new YoInteger(name + "Count", this.getRegistry());
        this.windowSize = new YoInteger(name + "WindowSize", this.getRegistry());
        this.initialize(yoVariableToFilter, windowSize);
    }

    public GlitchFilteredYoBoolean(String name, YoRegistry registry, YoBoolean yoVariableToFilter, int windowSize) {
        this(name, "", registry, yoVariableToFilter, windowSize);
    }

    public GlitchFilteredYoBoolean(String name, YoRegistry registry, YoBoolean yoVariableToFilter, YoInteger windowSize) {
        this(name, "", registry, yoVariableToFilter, windowSize);
    }

    public GlitchFilteredYoBoolean(String name, String description, YoRegistry registry, YoBoolean yoVariableToFilter, int windowSize) {
        this(name, description, registry, yoVariableToFilter, new YoInteger(name + "WindowSize", description, registry));
        this.windowSize.set(windowSize);
    }

    public GlitchFilteredYoBoolean(String name, String description, YoRegistry registry, YoBoolean yoVariableToFilter, YoInteger windowSize) {
        super(name, description, registry);
        this.counter = new YoInteger(name + "Count", description, registry);
        this.windowSize = windowSize;
        this.initialize(yoVariableToFilter, windowSize.getIntegerValue());
    }

    private void initialize(YoBoolean yoVariableToFilter, int windowSize) {
        if (windowSize < 0) {
            throw new RuntimeException("window size must be greater than 0");
        }
        this.variableToFilter = yoVariableToFilter;
        this.windowSize.set(windowSize);
        if (this.variableToFilter != null) {
            this.set(yoVariableToFilter.getBooleanValue());
        }
        this.set(false);
    }

    public boolean set(boolean value) {
        if (this.counter != null) {
            this.counter.set(0);
        }
        return super.set(value);
    }

    public void update(boolean value) {
        if (value != this.getBooleanValue()) {
            this.counter.set(this.counter.getIntegerValue() + 1);
        } else {
            this.counter.set(0);
        }
        if (this.counter.getIntegerValue() >= this.windowSize.getIntegerValue()) {
            this.set(value);
        }
    }

    public int getWindowSize() {
        return this.windowSize.getIntegerValue();
    }

    public void setWindowSize(int windowSize) {
        this.windowSize.set(windowSize);
    }

    public void update() {
        if (this.variableToFilter == null) {
            throw new RuntimeException("variableToFilter was not initialized. Use the other constructor");
        }
        this.update(this.variableToFilter.getBooleanValue());
    }
}

