/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.filters;

import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameQuaternion;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;

public class FiniteDifferenceAngularVelocityYoFrameVector
extends YoFrameVector3D {
    private final YoFrameQuaternion orientation;
    private final YoFrameQuaternion orientationPreviousValue;
    private final YoBoolean hasBeenCalled;
    private final RotationMatrix currentOrientationMatrix = new RotationMatrix();
    private final RotationMatrix previousOrientationMatrix = new RotationMatrix();
    private final RotationMatrix deltaOrientationMatrix = new RotationMatrix();
    private final AxisAngle deltaAxisAngle = new AxisAngle();
    private final double dt;

    public FiniteDifferenceAngularVelocityYoFrameVector(String namePrefix, ReferenceFrame referenceFrame, double dt, YoRegistry registry) {
        this(namePrefix, null, referenceFrame, dt, registry);
    }

    public FiniteDifferenceAngularVelocityYoFrameVector(String namePrefix, YoFrameQuaternion orientationToDifferentiate, double dt, YoRegistry registry) {
        this(namePrefix, orientationToDifferentiate, orientationToDifferentiate.getReferenceFrame(), dt, registry);
    }

    private FiniteDifferenceAngularVelocityYoFrameVector(String namePrefix, YoFrameQuaternion orientationToDifferentiate, ReferenceFrame referenceFrame, double dt, YoRegistry registry) {
        super(namePrefix, referenceFrame, registry);
        this.dt = dt;
        this.orientation = orientationToDifferentiate;
        this.orientationPreviousValue = new YoFrameQuaternion(namePrefix + "_previous", referenceFrame, registry);
        this.hasBeenCalled = new YoBoolean(namePrefix + "HasBeenCalled", registry);
        this.hasBeenCalled.set(false);
    }

    public void update() {
        if (this.orientation == null) {
            throw new NullPointerException("FiniteDifferenceAngularVelocityYoFrameVector must be constructed with a non null orientation variable to call update(), otherwise use update(FrameOrientation)");
        }
        this.currentOrientationMatrix.set((Orientation3DReadOnly)this.orientation);
        this.update((RotationMatrixReadOnly)this.currentOrientationMatrix);
    }

    public void update(FrameOrientation3DReadOnly currentOrientation) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)currentOrientation);
        this.currentOrientationMatrix.set((Orientation3DReadOnly)currentOrientation);
        this.update((RotationMatrixReadOnly)this.currentOrientationMatrix);
    }

    public void update(Orientation3DReadOnly currentOrientation) {
        this.currentOrientationMatrix.set(currentOrientation);
        this.update((RotationMatrixReadOnly)this.currentOrientationMatrix);
    }

    public void update(RotationMatrixReadOnly rotationMatrix) {
        if (!this.hasBeenCalled.getBooleanValue()) {
            this.orientationPreviousValue.set((Orientation3DReadOnly)rotationMatrix);
            this.hasBeenCalled.set(true);
        }
        if (rotationMatrix != this.currentOrientationMatrix) {
            this.currentOrientationMatrix.set(rotationMatrix);
        }
        this.previousOrientationMatrix.set((Orientation3DReadOnly)this.orientationPreviousValue);
        this.deltaOrientationMatrix.set(this.currentOrientationMatrix);
        this.deltaOrientationMatrix.multiplyTransposeOther((RotationMatrixReadOnly)this.previousOrientationMatrix);
        this.deltaAxisAngle.set((Orientation3DReadOnly)this.deltaOrientationMatrix);
        this.set(this.deltaAxisAngle.getX(), this.deltaAxisAngle.getY(), this.deltaAxisAngle.getZ());
        this.scale(this.deltaAxisAngle.getAngle() / this.dt);
        this.orientationPreviousValue.set((Orientation3DReadOnly)this.currentOrientationMatrix);
    }
}

