/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.filters;

import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector2D;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;

public class FilteredVelocityYoFrameVector2d
extends YoFrameVector2D {
    private final double dt;
    private final DoubleProvider alphaProvider;
    private final YoBoolean hasBeenCalled;
    private final FrameTuple2DReadOnly currentPosition;
    private final YoFrameVector2D lastPosition;
    private final Vector2D currentRawDerivative = new Vector2D();

    @Deprecated
    public static FilteredVelocityYoFrameVector2d createFilteredVelocityYoFrameVector2d(String namePrefix, String nameSuffix, DoubleProvider alpha, double dt, YoRegistry registry, FrameTuple2DReadOnly frameTuple2DToDifferentiate) {
        return new FilteredVelocityYoFrameVector2d(namePrefix, nameSuffix, alpha, dt, registry, frameTuple2DToDifferentiate);
    }

    @Deprecated
    public static FilteredVelocityYoFrameVector2d createFilteredVelocityYoFrameVector2d(String namePrefix, String nameSuffix, String description, DoubleProvider alpha, double dt, YoRegistry registry, FrameTuple2DReadOnly frameTuple2DToDifferentiate) {
        return new FilteredVelocityYoFrameVector2d(namePrefix, nameSuffix, alpha, dt, registry, frameTuple2DToDifferentiate);
    }

    @Deprecated
    public static FilteredVelocityYoFrameVector2d createFilteredVelocityYoFrameVector2d(String namePrefix, String nameSuffix, DoubleProvider alpha, double dt, YoRegistry registry, ReferenceFrame referenceFrame) {
        return new FilteredVelocityYoFrameVector2d(namePrefix, nameSuffix, alpha, dt, registry, referenceFrame);
    }

    public FilteredVelocityYoFrameVector2d(String namePrefix, String nameSuffix, DoubleProvider alpha, double dt, YoRegistry registry, FrameTuple2DReadOnly frameTuple2DToDifferentiate) {
        super(namePrefix, nameSuffix, frameTuple2DToDifferentiate.getReferenceFrame(), registry);
        this.alphaProvider = alpha;
        this.dt = dt;
        this.hasBeenCalled = new YoBoolean(namePrefix + nameSuffix + "HasBeenCalled", registry);
        this.currentPosition = frameTuple2DToDifferentiate;
        this.lastPosition = new YoFrameVector2D(namePrefix + "_lastPosition", nameSuffix, this.getReferenceFrame(), registry);
        this.reset();
    }

    public FilteredVelocityYoFrameVector2d(String namePrefix, String nameSuffix, DoubleProvider alpha, double dt, YoRegistry registry, ReferenceFrame referenceFrame) {
        super(namePrefix, nameSuffix, referenceFrame, registry);
        this.alphaProvider = alpha;
        this.dt = dt;
        this.hasBeenCalled = new YoBoolean(namePrefix + nameSuffix + "HasBeenCalled", registry);
        this.currentPosition = null;
        this.lastPosition = new YoFrameVector2D(namePrefix + "_lastPosition", nameSuffix, this.getReferenceFrame(), registry);
        this.reset();
    }

    public void reset() {
        this.hasBeenCalled.set(false);
    }

    public void update() {
        if (this.currentPosition == null) {
            throw new NullPointerException(((Object)((Object)this)).getClass().getSimpleName() + " must be constructed with a non null position variable to call update(), otherwise use update(FrameTuple3DReadOnly)");
        }
        this.update(this.currentPosition);
    }

    public void update(FrameTuple2DReadOnly frameTuple) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)frameTuple);
        this.update((Tuple2DReadOnly)frameTuple);
    }

    public void update(Tuple2DReadOnly currentPosition) {
        if (!this.hasBeenCalled.getBooleanValue()) {
            this.hasBeenCalled.set(true);
            this.lastPosition.set(currentPosition);
            this.setToZero();
        }
        this.currentRawDerivative.sub(currentPosition, (Tuple2DReadOnly)this.lastPosition);
        this.currentRawDerivative.scale(1.0 / this.dt);
        this.interpolate((Tuple2DReadOnly)this.currentRawDerivative, (FrameTuple2DReadOnly)this, this.alphaProvider.getValue());
        this.lastPosition.set(currentPosition);
    }
}

