/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.filters;

import us.ihmc.robotics.math.TimestampedVelocityYoVariable;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class FilteredDiscreteVelocityYoVariable3
extends YoDouble {
    private final YoDouble time;
    private final YoDouble position;
    private final YoDouble timeSinceLastPosChange;
    private final YoDouble lastPosChangeTimeInterval;
    private final TimestampedVelocityYoVariable finiteDifferenceVelocity;
    private final TimestampedVelocityYoVariable finiteDifferenceAccel;
    private final YoDouble velocityIfEncoderTicksNowConstantAccel;
    private boolean updateHasBeenCalled;
    private final YoBoolean assumeConstantAccel;
    private final double alpha;
    private final YoDouble alphaVariable;

    public FilteredDiscreteVelocityYoVariable3(String name, String description, double alpha, YoDouble time, YoRegistry registry) {
        super(name, description, registry);
        this.time = time;
        this.position = null;
        this.timeSinceLastPosChange = new YoDouble(name + "_timeSinceLastTick", registry);
        this.lastPosChangeTimeInterval = new YoDouble(name + "_lastUpdateTimeInterval", registry);
        this.finiteDifferenceVelocity = new TimestampedVelocityYoVariable(name + "_finiteDiff", "", this.position, time, registry, 1.0E-20);
        this.finiteDifferenceAccel = new TimestampedVelocityYoVariable(name + "_finiteDiffAccel", "", this.finiteDifferenceVelocity, time, registry, 1.0E-20);
        this.velocityIfEncoderTicksNowConstantAccel = new YoDouble(name + "_velocityIfEncoderTicksNowConstantAccel", registry);
        this.assumeConstantAccel = new YoBoolean(name + "_assumeConstAccel", registry);
        this.alpha = alpha;
        this.alphaVariable = null;
        this.reset();
    }

    public FilteredDiscreteVelocityYoVariable3(String name, String description, double alpha, YoDouble positionVariable, YoDouble time, YoRegistry registry) {
        super(name, description, registry);
        this.time = time;
        this.position = positionVariable;
        this.timeSinceLastPosChange = new YoDouble(name + "_timeSinceLastTick", registry);
        this.lastPosChangeTimeInterval = new YoDouble(name + "_lastUpdateTimeInterval", registry);
        this.finiteDifferenceVelocity = new TimestampedVelocityYoVariable(name + "_finiteDiff", "", this.position, time, registry, 1.0E-20);
        this.finiteDifferenceAccel = new TimestampedVelocityYoVariable(name + "_finiteDiffAccel", "", this.finiteDifferenceVelocity, time, registry, 1.0E-20);
        this.velocityIfEncoderTicksNowConstantAccel = new YoDouble(name + "_velocityIfEncoderTicksNowConstantAccel", registry);
        this.assumeConstantAccel = new YoBoolean(name + "_assumeConstAccel", registry);
        this.alpha = alpha;
        this.alphaVariable = null;
        this.reset();
    }

    public FilteredDiscreteVelocityYoVariable3(String name, String description, YoDouble alphaVariable, YoDouble positionVariable, YoDouble time, YoRegistry registry) {
        super(name, description, registry);
        this.time = time;
        this.position = positionVariable;
        this.timeSinceLastPosChange = new YoDouble(name + "_timeSinceLastTick", registry);
        this.lastPosChangeTimeInterval = new YoDouble(name + "_lastUpdateTimeInterval", registry);
        this.finiteDifferenceVelocity = new TimestampedVelocityYoVariable(name + "_finiteDiff", "", this.position, time, registry, 1.0E-20);
        this.finiteDifferenceAccel = new TimestampedVelocityYoVariable(name + "_finiteDiffAccel", "", this.finiteDifferenceVelocity, time, registry, 1.0E-20);
        this.velocityIfEncoderTicksNowConstantAccel = new YoDouble(name + "_velocityIfEncoderTicksNowConstantAccel", registry);
        this.assumeConstantAccel = new YoBoolean(name + "_assumeConstAccel", registry);
        this.alphaVariable = alphaVariable;
        this.alpha = 0.0;
        this.reset();
    }

    public void reset() {
        this.updateHasBeenCalled = false;
        this.assumeConstantAccel.set(true);
    }

    public void update() {
        if (this.position == null) {
            throw new NullPointerException("YoFilteredVelocityVariable must be constructed with a non null position variable to call update(), otherwise use update(double)");
        }
        this.update(this.position.getDoubleValue());
    }

    public void update(double currentPosition) {
        if (!this.updateHasBeenCalled) {
            this.updateHasBeenCalled = true;
        }
        this.timeSinceLastPosChange.set(this.time.getDoubleValue() - this.finiteDifferenceVelocity.getPreviousTimestamp());
        double previousPositon = this.finiteDifferenceVelocity.getPreviousPosition();
        if (currentPosition != previousPositon) {
            this.finiteDifferenceVelocity.update();
            this.finiteDifferenceAccel.update();
            this.lastPosChangeTimeInterval.set(this.timeSinceLastPosChange.getDoubleValue());
        } else {
            this.velocityIfEncoderTicksNowConstantAccel.set(this.finiteDifferenceVelocity.getDoubleValue() + this.finiteDifferenceAccel.getDoubleValue() * this.timeSinceLastPosChange.getDoubleValue());
        }
        if (this.assumeConstantAccel.getBooleanValue()) {
            this.set(this.alphaFilter(this.velocityIfEncoderTicksNowConstantAccel.getDoubleValue()));
        } else {
            this.set(this.alphaFilter(this.finiteDifferenceVelocity.getDoubleValue()));
        }
    }

    private double alphaFilter(double currentValue) {
        double previousFilteredValue = this.getDoubleValue();
        double a = this.alpha;
        if (this.alphaVariable != null) {
            a = this.alphaVariable.getDoubleValue();
        }
        double ret = a * previousFilteredValue + (1.0 - a) * currentValue;
        return ret;
    }
}

