/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.filters;

import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class DelayedYoDouble
extends YoDouble {
    private final YoDouble variableToDelay;
    private final YoDouble[] previousYoVariables;

    public DelayedYoDouble(String name, String description, YoDouble variableToDelay, int ticksToDelay, YoRegistry registry) {
        super(name, description, registry);
        this.variableToDelay = variableToDelay;
        this.previousYoVariables = new YoDouble[ticksToDelay];
        for (int i = 0; i < ticksToDelay; ++i) {
            this.previousYoVariables[i] = new YoDouble(name + "_previous" + i, registry);
            this.previousYoVariables[i].set(variableToDelay.getDoubleValue());
        }
        this.set(variableToDelay.getDoubleValue());
    }

    public void update() {
        if (this.previousYoVariables.length == 0) {
            this.set(this.variableToDelay.getDoubleValue());
            return;
        }
        this.set(this.previousYoVariables[0].getDoubleValue());
        for (int i = 0; i < this.previousYoVariables.length - 1; ++i) {
            this.previousYoVariables[i].set(this.previousYoVariables[i + 1].getDoubleValue());
        }
        this.previousYoVariables[this.previousYoVariables.length - 1].set(this.variableToDelay.getDoubleValue());
    }

    public void reset() {
        for (YoDouble var : this.previousYoVariables) {
            var.set(this.variableToDelay.getDoubleValue());
        }
        this.set(this.variableToDelay.getDoubleValue());
    }
}

