/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.filters;

import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;

public class DelayedYoBoolean
extends YoBoolean {
    private final YoBoolean variableToDelay;
    private final YoBoolean[] previousYoVariables;

    public DelayedYoBoolean(String name, String description, YoBoolean variableToDelay, int ticksToDelay, YoRegistry registry) {
        super(name, description, registry);
        this.variableToDelay = variableToDelay;
        this.previousYoVariables = new YoBoolean[ticksToDelay];
        for (int i = 0; i < ticksToDelay; ++i) {
            this.previousYoVariables[i] = new YoBoolean(name + "_previous" + i, registry);
            this.previousYoVariables[i].set(variableToDelay.getBooleanValue());
        }
        this.set(variableToDelay.getBooleanValue());
    }

    public void update() {
        if (this.previousYoVariables.length == 0) {
            this.set(this.variableToDelay.getBooleanValue());
            return;
        }
        this.set(this.previousYoVariables[0].getBooleanValue());
        for (int i = 0; i < this.previousYoVariables.length - 1; ++i) {
            this.previousYoVariables[i].set(this.previousYoVariables[i + 1].getBooleanValue());
        }
        this.previousYoVariables[this.previousYoVariables.length - 1].set(this.variableToDelay.getBooleanValue());
    }

    public void reset() {
        for (YoBoolean var : this.previousYoVariables) {
            var.set(this.variableToDelay.getBooleanValue());
        }
        this.set(this.variableToDelay.getBooleanValue());
    }

    void getInternalState(String inputString, Boolean ifDebug) {
        if (!ifDebug.booleanValue()) {
            return;
        }
        String string = inputString + "\nvalue = " + this.getBooleanValue() + "\n";
        for (int i = 0; i < this.previousYoVariables.length; ++i) {
            string = string + i + " = " + this.previousYoVariables[i].getBooleanValue() + "\n";
        }
        string = string + "variableToDelay = " + this.variableToDelay.getBooleanValue() + "\n";
        System.out.println(string);
    }
}

