/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.filters;

import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.robotics.math.filters.DeadzoneYoVariable;
import us.ihmc.robotics.math.filters.ProcessingYoVariable;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameTuple3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.tools.YoGeometryNameTools;
import us.ihmc.yoVariables.variable.YoDouble;

public class DeadzoneYoFrameVector
extends YoFrameVector3D
implements ProcessingYoVariable {
    private final DeadzoneYoVariable x;
    private final DeadzoneYoVariable y;
    private final DeadzoneYoVariable z;

    private DeadzoneYoFrameVector(DeadzoneYoVariable x, DeadzoneYoVariable y, DeadzoneYoVariable z, ReferenceFrame referenceFrame) {
        super((YoDouble)x, (YoDouble)y, (YoDouble)z, referenceFrame);
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static DeadzoneYoFrameVector createDeadzoneYoFrameVector(String namePrefix, YoRegistry registry, YoDouble deadzoneSize, ReferenceFrame referenceFrame) {
        return DeadzoneYoFrameVector.createDeadzoneYoFrameVector(namePrefix, "", registry, deadzoneSize, referenceFrame);
    }

    public static DeadzoneYoFrameVector createDeadzoneYoFrameVector(String namePrefix, String nameSuffix, YoRegistry registry, YoDouble deadzoneSize, ReferenceFrame referenceFrame) {
        DeadzoneYoVariable x = new DeadzoneYoVariable(YoGeometryNameTools.createXName((String)namePrefix, (String)nameSuffix), deadzoneSize, registry);
        DeadzoneYoVariable y = new DeadzoneYoVariable(YoGeometryNameTools.createYName((String)namePrefix, (String)nameSuffix), deadzoneSize, registry);
        DeadzoneYoVariable z = new DeadzoneYoVariable(YoGeometryNameTools.createZName((String)namePrefix, (String)nameSuffix), deadzoneSize, registry);
        DeadzoneYoFrameVector ret = new DeadzoneYoFrameVector(x, y, z, referenceFrame);
        return ret;
    }

    public static DeadzoneYoFrameVector createDeadzoneYoFrameVector(String namePrefix, YoRegistry registry, YoDouble deadzoneSize, YoFrameTuple3D rawTuple) {
        return DeadzoneYoFrameVector.createDeadzoneYoFrameVector(namePrefix, "", registry, deadzoneSize, rawTuple);
    }

    public static DeadzoneYoFrameVector createDeadzoneYoFrameVector(String namePrefix, String nameSuffix, YoRegistry registry, YoDouble deadzoneSize, YoFrameTuple3D rawTuple) {
        DeadzoneYoVariable x = new DeadzoneYoVariable(YoGeometryNameTools.createXName((String)namePrefix, (String)nameSuffix), rawTuple.getYoX(), deadzoneSize, registry);
        DeadzoneYoVariable y = new DeadzoneYoVariable(YoGeometryNameTools.createYName((String)namePrefix, (String)nameSuffix), rawTuple.getYoY(), deadzoneSize, registry);
        DeadzoneYoVariable z = new DeadzoneYoVariable(YoGeometryNameTools.createZName((String)namePrefix, (String)nameSuffix), rawTuple.getYoZ(), deadzoneSize, registry);
        DeadzoneYoFrameVector ret = new DeadzoneYoFrameVector(x, y, z, rawTuple.getReferenceFrame());
        return ret;
    }

    @Override
    public void update() {
        this.x.update();
        this.y.update();
        this.z.update();
    }

    public void update(FrameTuple3DReadOnly frameTuple) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)frameTuple);
        this.x.update(frameTuple.getX());
        this.y.update(frameTuple.getY());
        this.z.update(frameTuple.getZ());
    }
}

