/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.filters;

import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class AlphaFusedYoVariable
extends YoDouble {
    private final double alpha;
    private final DoubleProvider alphaVariable;
    private final YoDouble slowSignal;
    private final YoDouble fastSignal;
    private final YoDouble steadyStateOffset;
    private final YoBoolean hasBeenCalled;

    public AlphaFusedYoVariable(String name, YoRegistry yoVariableRegistry, double alpha) {
        super(name, yoVariableRegistry);
        this.hasBeenCalled = new YoBoolean(name + "HasBeenCalled", yoVariableRegistry);
        this.alpha = alpha;
        this.alphaVariable = null;
        this.slowSignal = null;
        this.fastSignal = null;
        this.steadyStateOffset = new YoDouble(name + "_off", yoVariableRegistry);
        this.reset();
    }

    public AlphaFusedYoVariable(String name, YoRegistry yoVariableRegistry, double alpha, YoDouble slowSignal, YoDouble fastSignal) {
        super(name, yoVariableRegistry);
        this.hasBeenCalled = new YoBoolean(name + "HasBeenCalled", yoVariableRegistry);
        this.alpha = alpha;
        this.alphaVariable = null;
        this.slowSignal = slowSignal;
        this.fastSignal = fastSignal;
        this.steadyStateOffset = new YoDouble(name + "_off", yoVariableRegistry);
        this.reset();
    }

    public AlphaFusedYoVariable(String name, YoRegistry yoVariableRegistry, DoubleProvider alphaVariable, YoDouble slowSignal, YoDouble fastSignal) {
        super(name, yoVariableRegistry);
        this.hasBeenCalled = new YoBoolean(name + "HasBeenCalled", yoVariableRegistry);
        this.alpha = 0.0;
        this.alphaVariable = alphaVariable;
        this.slowSignal = slowSignal;
        this.fastSignal = fastSignal;
        this.steadyStateOffset = new YoDouble(name + "_off", yoVariableRegistry);
        this.reset();
    }

    public void reset() {
        this.hasBeenCalled.set(false);
        this.steadyStateOffset.set(0.0);
    }

    public void update() {
        if (this.slowSignal == null || this.fastSignal == null) {
            throw new NullPointerException("YoAlphaFusedVariable must be constructed with non null signal variables to call update(), otherwise use update(double, double)");
        }
        this.update(this.slowSignal.getDoubleValue(), this.fastSignal.getDoubleValue());
    }

    public void update(double slowSignalVal, double fastSignalVal) {
        if (!this.hasBeenCalled.getBooleanValue()) {
            this.hasBeenCalled.set(true);
            this.steadyStateOffset.set(0.0);
            this.set(slowSignalVal);
        }
        double alphaValue = this.alphaVariable == null ? this.alpha : this.alphaVariable.getValue();
        this.steadyStateOffset.set(this.steadyStateOffset.getDoubleValue() + alphaValue * (this.getDoubleValue() - slowSignalVal));
        this.set(fastSignalVal - this.steadyStateOffset.getDoubleValue());
    }
}

