/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.filters;

import us.ihmc.commons.MathTools;
import us.ihmc.robotics.math.filters.ProcessingYoVariable;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class AlphaFilteredYoVariable
extends YoDouble
implements ProcessingYoVariable {
    private final DoubleProvider alphaVariable;
    private final YoDouble position;
    protected final YoBoolean hasBeenCalled;

    public static DoubleProvider createAlphaYoDouble(String namePrefix, double initialValue, YoRegistry registry) {
        YoDouble maxRate = new YoDouble(namePrefix + "AlphaVariable", registry);
        maxRate.set(initialValue);
        return maxRate;
    }

    public AlphaFilteredYoVariable(String name, YoRegistry registry, double alpha) {
        this(name, registry, alpha, null);
    }

    public AlphaFilteredYoVariable(String name, YoRegistry registry, double alpha, YoDouble positionVariable) {
        this(name, "", registry, AlphaFilteredYoVariable.createAlphaYoDouble(name, alpha, registry), positionVariable);
    }

    public AlphaFilteredYoVariable(String name, YoRegistry registry, DoubleProvider alphaVariable) {
        this(name, "", registry, alphaVariable, null);
    }

    public AlphaFilteredYoVariable(String name, String description, YoRegistry registry, DoubleProvider alphaVariable) {
        this(name, description, registry, alphaVariable, null);
    }

    public AlphaFilteredYoVariable(String name, YoRegistry registry, DoubleProvider alphaVariable, YoDouble positionVariable) {
        this(name, "", registry, alphaVariable, positionVariable);
    }

    public AlphaFilteredYoVariable(String name, String description, YoRegistry registry, DoubleProvider alphaVariable, YoDouble positionVariable) {
        super(name, description, registry);
        this.hasBeenCalled = new YoBoolean(name + "HasBeenCalled", description, registry);
        this.position = positionVariable;
        if (alphaVariable == null) {
            alphaVariable = AlphaFilteredYoVariable.createAlphaYoDouble(name, 0.0, registry);
        }
        this.alphaVariable = alphaVariable;
        this.reset();
    }

    @Override
    public void reset() {
        this.hasBeenCalled.set(false);
    }

    @Override
    public void update() {
        if (this.position == null) {
            throw new NullPointerException("YoAlphaFilteredVariable must be constructed with a non null position variable to call update(), otherwise use update(double)");
        }
        this.update(this.position.getDoubleValue());
    }

    public void update(double currentPosition) {
        if (!this.hasBeenCalled.getBooleanValue()) {
            this.hasBeenCalled.set(true);
            this.set(currentPosition);
        } else {
            double alpha = this.alphaVariable.getValue();
            this.set(alpha * this.getDoubleValue() + (1.0 - alpha) * currentPosition);
        }
    }

    @Deprecated
    public static double computeAlphaGivenBreakFrequency(double breakFrequencyInHertz, double dt) {
        if (Double.isInfinite(breakFrequencyInHertz)) {
            return 0.0;
        }
        double alpha = 1.0 - breakFrequencyInHertz * 2.0 * Math.PI * dt;
        alpha = MathTools.clamp((double)alpha, (double)0.0, (double)1.0);
        return alpha;
    }

    public static double computeAlphaGivenBreakFrequencyProperly(double breakFrequencyInHertz, double dt) {
        if (Double.isInfinite(breakFrequencyInHertz)) {
            return 0.0;
        }
        double omega = Math.PI * 2 * breakFrequencyInHertz;
        double alpha = (1.0 - omega * dt / 2.0) / (1.0 + omega * dt / 2.0);
        alpha = MathTools.clamp((double)alpha, (double)0.0, (double)1.0);
        return alpha;
    }

    public static double computeBreakFrequencyGivenAlpha(double alpha, double dt) {
        return (1.0 - alpha) / (Math.PI * dt * (1.0 + alpha));
    }

    public static void main(String[] args) {
        double dt = 0.001;
        for (double i = 2.0; i < 1.0 / dt; i *= 1.2) {
            double alpha = AlphaFilteredYoVariable.computeAlphaGivenBreakFrequency(i, dt);
            double alphaProperly = AlphaFilteredYoVariable.computeAlphaGivenBreakFrequencyProperly(i, dt);
            System.out.println("freq=" + i + ", alpha=" + alpha + ", alphaProperly=" + alphaProperly);
        }
        System.out.println(AlphaFilteredYoVariable.computeBreakFrequencyGivenAlpha(0.8, 0.006));
        System.out.println(AlphaFilteredYoVariable.computeAlphaGivenBreakFrequencyProperly(20.0, 0.006));
        System.out.println(AlphaFilteredYoVariable.computeAlphaGivenBreakFrequencyProperly(20.0, 0.003));
    }

    public boolean getHasBeenCalled() {
        return this.hasBeenCalled.getBooleanValue();
    }
}

