/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.filters;

import us.ihmc.commons.MathTools;
import us.ihmc.robotics.math.filters.AlphaFilteredYoVariable;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class AlphaFilteredWrappingYoVariable
extends AlphaFilteredYoVariable {
    public static final double EPSILON = 1.0E-10;
    private double previousUnfilteredVariable;
    private final YoDouble unfilteredVariable;
    private final YoDouble unfilteredInRangeVariable;
    private final DoubleProvider alphaVariable;
    private final YoDouble temporaryOutputVariable;
    private final YoDouble error;
    private final double upperLimit;
    private final double lowerLimit;
    private final double range;

    public AlphaFilteredWrappingYoVariable(String name, String description, YoRegistry registry, YoDouble unfilteredVariable, DoubleProvider alphaVariable, double lowerLimit, double upperLimit) {
        super(name, description, registry, alphaVariable);
        this.alphaVariable = alphaVariable;
        this.upperLimit = upperLimit;
        this.lowerLimit = lowerLimit;
        this.range = upperLimit - lowerLimit;
        this.unfilteredVariable = unfilteredVariable;
        this.unfilteredInRangeVariable = new YoDouble(name + "UnfilteredInRangeVariable", registry);
        this.temporaryOutputVariable = new YoDouble(name + "TemporaryOutputVariable", registry);
        this.error = new YoDouble(name + "Error", registry);
    }

    @Override
    public void update() {
        this.update(this.unfilteredVariable.getDoubleValue());
    }

    @Override
    public void update(double currentPosition) {
        if (!this.hasBeenCalled.getBooleanValue()) {
            this.hasBeenCalled.set(true);
            this.previousUnfilteredVariable = this.unfilteredVariable.getDoubleValue();
            this.unfilteredVariableModulo(currentPosition);
            this.temporaryOutputVariable.set(this.unfilteredInRangeVariable.getDoubleValue());
            this.set(this.unfilteredInRangeVariable.getDoubleValue());
        } else {
            if (!MathTools.epsilonEquals((double)currentPosition, (double)this.previousUnfilteredVariable, (double)1.0E-10)) {
                this.previousUnfilteredVariable = currentPosition;
                this.unfilteredVariableModulo(currentPosition);
                double standardError = this.unfilteredInRangeVariable.getDoubleValue() - this.getDoubleValue();
                double wrappingError = this.unfilteredInRangeVariable.getDoubleValue() > this.getDoubleValue() ? this.lowerLimit - this.getDoubleValue() + this.unfilteredInRangeVariable.getDoubleValue() - this.upperLimit : this.upperLimit - this.getDoubleValue() + this.unfilteredInRangeVariable.getDoubleValue() - this.lowerLimit;
                if (Math.abs(standardError) < Math.abs(wrappingError)) {
                    this.error.set(standardError);
                } else {
                    this.error.set(wrappingError);
                }
                this.temporaryOutputVariable.set(this.getDoubleValue());
                if (this.getDoubleValue() + this.error.getDoubleValue() >= this.upperLimit) {
                    this.temporaryOutputVariable.set(this.getDoubleValue() - this.range);
                }
                if (this.getDoubleValue() + this.error.getDoubleValue() < this.lowerLimit) {
                    this.temporaryOutputVariable.set(this.getDoubleValue() + this.range);
                }
            }
            this.temporaryOutputVariable.set(this.alphaVariable.getValue() * this.temporaryOutputVariable.getDoubleValue() + (1.0 - this.alphaVariable.getValue()) * this.unfilteredInRangeVariable.getDoubleValue());
            if (this.temporaryOutputVariable.getDoubleValue() > this.upperLimit + 1.0E-10) {
                this.set(this.temporaryOutputVariable.getDoubleValue() - this.range);
            } else if (this.temporaryOutputVariable.getDoubleValue() <= this.lowerLimit - 1.0E-10) {
                this.set(this.temporaryOutputVariable.getDoubleValue() + this.range);
            } else {
                this.set(this.temporaryOutputVariable.getDoubleValue());
            }
        }
    }

    private void unfilteredVariableModulo(double currentPosition) {
        boolean rangeNeedsToBeChecked = true;
        this.unfilteredInRangeVariable.set(currentPosition);
        while (rangeNeedsToBeChecked) {
            rangeNeedsToBeChecked = false;
            if (this.unfilteredInRangeVariable.getDoubleValue() >= this.upperLimit) {
                this.unfilteredInRangeVariable.set(this.unfilteredInRangeVariable.getDoubleValue() - this.range);
                rangeNeedsToBeChecked = true;
            }
            if (!(this.unfilteredInRangeVariable.getDoubleValue() < this.lowerLimit)) continue;
            this.unfilteredInRangeVariable.set(this.unfilteredInRangeVariable.getDoubleValue() + this.range);
            rangeNeedsToBeChecked = true;
        }
    }
}

