/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.filters;

import org.apache.commons.lang3.NotImplementedException;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.yoVariables.providers.DoubleProvider;

public class AlphaFilteredTuple2D
implements Tuple2DBasics {
    private final DoubleProvider alpha;
    private boolean resetX;
    private boolean resetY;
    private double x;
    private double y;

    public AlphaFilteredTuple2D(DoubleProvider alpha) {
        this.alpha = alpha;
        this.reset();
    }

    public AlphaFilteredTuple2D(Tuple2DReadOnly other, DoubleProvider alpha) {
        this.alpha = alpha;
        this.reset(other);
    }

    public void reset() {
        this.resetX = true;
        this.resetY = true;
    }

    public void reset(Tuple2DReadOnly other) {
        this.resetX = true;
        this.resetY = true;
        this.set(other);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public void setX(double x) {
        if (this.resetX) {
            this.x = x;
            this.resetX = false;
        } else {
            this.x = this.alpha.getValue() * this.x + (1.0 - this.alpha.getValue()) * x;
        }
    }

    public void setY(double y) {
        if (this.resetY) {
            this.y = y;
            this.resetY = false;
        } else {
            this.y = this.alpha.getValue() * this.y + (1.0 - this.alpha.getValue()) * y;
        }
    }

    public void applyTransform(Transform transform, boolean checkIfTransformInXYPlane) {
        throw new NotImplementedException("Not supported by " + this.getClass().getSimpleName() + ".");
    }

    public void applyInverseTransform(Transform transform, boolean checkIfTransformInXYPlane) {
        throw new NotImplementedException("Not supported by " + this.getClass().getSimpleName() + ".");
    }

    public boolean geometricallyEquals(EuclidGeometry geometry, double epsilon) {
        return this.epsilonEquals(geometry, epsilon);
    }
}

