/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.filters;

import us.ihmc.commons.MathTools;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class AccelerationLimitedYoVariable
extends YoDouble {
    private final double dt;
    private final YoBoolean hasBeenInitialized;
    private final YoDouble smoothedRate;
    private final YoDouble smoothedAcceleration;
    private final YoDouble positionGain;
    private final YoDouble velocityGain;
    private DoubleProvider maximumRate;
    private DoubleProvider maximumAcceleration;
    private final DoubleProvider inputVariable;

    public AccelerationLimitedYoVariable(String name, YoRegistry registry, DoubleProvider maxRate, DoubleProvider maxAcceleration, double dt) {
        this(name, registry, maxRate, maxAcceleration, null, dt);
    }

    public AccelerationLimitedYoVariable(String name, YoRegistry registry, DoubleProvider maxRate, DoubleProvider maxAcceleration, DoubleProvider inputVariable, double dt) {
        super(name, registry);
        if (maxRate != null && maxAcceleration != null) {
            this.maximumRate = maxRate;
            this.maximumAcceleration = maxAcceleration;
        }
        this.dt = dt;
        this.hasBeenInitialized = new YoBoolean(name + "HasBeenInitialized", registry);
        this.smoothedRate = new YoDouble(name + "SmoothedRate", registry);
        this.smoothedAcceleration = new YoDouble(name + "SmoothedAcceleration", registry);
        this.positionGain = new YoDouble(name + "PositionGain", registry);
        this.velocityGain = new YoDouble(name + "VelocityGain", registry);
        double w0 = 100.53096491487338;
        double zeta = 1.0;
        this.setGainsByPolePlacement(w0, zeta);
        this.hasBeenInitialized.set(false);
        this.inputVariable = inputVariable;
    }

    public void setGainsByPolePlacement(double w0, double zeta) {
        this.positionGain.set(w0 * w0);
        this.velocityGain.set(2.0 * zeta * w0);
    }

    public YoDouble getPositionGain() {
        return this.positionGain;
    }

    public YoDouble getVelocityGain() {
        return this.velocityGain;
    }

    public void update() {
        this.update(this.inputVariable.getValue());
    }

    public void update(double input) {
        if (!this.hasBeenInitialized.getBooleanValue()) {
            this.initialize(input);
        }
        double positionError = input - this.getDoubleValue();
        double acceleration = -this.velocityGain.getDoubleValue() * this.smoothedRate.getDoubleValue() + this.positionGain.getDoubleValue() * positionError;
        acceleration = MathTools.clamp((double)acceleration, (double)(-this.maximumAcceleration.getValue()), (double)this.maximumAcceleration.getValue());
        this.smoothedAcceleration.set(acceleration);
        this.smoothedRate.add(this.smoothedAcceleration.getDoubleValue() * this.dt);
        this.smoothedRate.set(MathTools.clamp((double)this.smoothedRate.getDoubleValue(), (double)this.maximumRate.getValue()));
        this.add(this.smoothedRate.getDoubleValue() * this.dt);
    }

    public void initialize(double input) {
        this.set(input);
        this.smoothedRate.set(0.0);
        this.smoothedAcceleration.set(0.0);
        this.hasBeenInitialized.set(true);
    }

    public void reset() {
        this.hasBeenInitialized.set(false);
        this.smoothedRate.set(0.0);
        this.smoothedAcceleration.set(0.0);
    }

    public YoDouble getSmoothedRate() {
        return this.smoothedRate;
    }

    public YoDouble getSmoothedAcceleration() {
        return this.smoothedAcceleration;
    }

    public boolean hasBeenInitialized() {
        return this.hasBeenInitialized.getBooleanValue();
    }

    public double getMaximumRate() {
        return this.maximumRate.getValue();
    }

    public double getMaximumAcceleration() {
        return this.maximumAcceleration.getValue();
    }
}

