/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.filters;

import us.ihmc.euclid.referenceFrame.FrameVector2D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.robotics.math.filters.AccelerationLimitedYoVariable;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector2D;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.tools.YoGeometryNameTools;
import us.ihmc.yoVariables.variable.YoDouble;

public class AccelerationLimitedYoFrameVector2d
extends YoFrameVector2D {
    private final AccelerationLimitedYoVariable x;
    private final AccelerationLimitedYoVariable y;

    private AccelerationLimitedYoFrameVector2d(AccelerationLimitedYoVariable x, AccelerationLimitedYoVariable y, ReferenceFrame referenceFrame) {
        super((YoDouble)x, (YoDouble)y, referenceFrame);
        this.x = x;
        this.y = y;
    }

    public static AccelerationLimitedYoFrameVector2d createAccelerationLimitedYoFrameVector2d(String namePrefix, String nameSuffix, YoRegistry registry, DoubleProvider maxRate, DoubleProvider maxAcceleration, double dt, ReferenceFrame referenceFrame) {
        AccelerationLimitedYoVariable x = new AccelerationLimitedYoVariable(YoGeometryNameTools.createXName((String)namePrefix, (String)nameSuffix), registry, maxRate, maxAcceleration, dt);
        AccelerationLimitedYoVariable y = new AccelerationLimitedYoVariable(YoGeometryNameTools.createYName((String)namePrefix, (String)nameSuffix), registry, maxRate, maxAcceleration, dt);
        AccelerationLimitedYoFrameVector2d ret = new AccelerationLimitedYoFrameVector2d(x, y, referenceFrame);
        return ret;
    }

    public static AccelerationLimitedYoFrameVector2d createAccelerationLimitedYoFrameVector2d(String namePrefix, String nameSuffix, YoRegistry registry, DoubleProvider maxRate, DoubleProvider maxAcceleration, double dt, YoFrameVector2D unfilteredVector) {
        AccelerationLimitedYoVariable x = new AccelerationLimitedYoVariable(YoGeometryNameTools.createXName((String)namePrefix, (String)nameSuffix), registry, maxRate, maxAcceleration, (DoubleProvider)unfilteredVector.getYoX(), dt);
        AccelerationLimitedYoVariable y = new AccelerationLimitedYoVariable(YoGeometryNameTools.createYName((String)namePrefix, (String)nameSuffix), registry, maxRate, maxAcceleration, (DoubleProvider)unfilteredVector.getYoY(), dt);
        AccelerationLimitedYoFrameVector2d ret = new AccelerationLimitedYoFrameVector2d(x, y, unfilteredVector.getReferenceFrame());
        return ret;
    }

    public void setGainsByPolePlacement(double w0, double zeta) {
        this.x.setGainsByPolePlacement(w0, zeta);
        this.y.setGainsByPolePlacement(w0, zeta);
    }

    public void update() {
        this.x.update();
        this.y.update();
    }

    public void update(double xUnfiltered, double yUnfiltered) {
        this.x.update(xUnfiltered);
        this.y.update(yUnfiltered);
    }

    public void update(Vector2D vector2dUnfiltered) {
        this.x.update(vector2dUnfiltered.getX());
        this.y.update(vector2dUnfiltered.getY());
    }

    public void update(FrameVector2D vector2dUnfiltered) {
        this.x.update(vector2dUnfiltered.getX());
        this.y.update(vector2dUnfiltered.getY());
    }

    public void reset() {
        this.x.reset();
        this.y.reset();
    }
}

