/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math;

import us.ihmc.log.LogTools;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoEnum;

public class YoVariableLimitChecker {
    private final YoEnum<LimitStatus> status;
    private final DoubleProvider lowerLimit;
    private final DoubleProvider upperLimit;
    private final YoDouble variableToCheck;

    public YoVariableLimitChecker(YoDouble variableToCheck, String prefix, DoubleProvider lowerLimit, DoubleProvider upperLimit, YoRegistry registry) {
        this.status = new YoEnum(prefix + variableToCheck.getName() + "_Status", registry, LimitStatus.class);
        this.lowerLimit = lowerLimit;
        this.upperLimit = upperLimit;
        this.variableToCheck = variableToCheck;
    }

    public LimitStatus update() {
        if (this.upperLimit.getValue() < this.lowerLimit.getValue()) {
            LogTools.warn((String)"Not checking joint limits, since they aren't valid. Upper limit must be greater than lower limit.");
            return null;
        }
        if (this.variableToCheck.getDoubleValue() > this.upperLimit.getValue()) {
            this.status.set((Enum)LimitStatus.ABOVE_LIMIT);
        } else if (this.variableToCheck.getDoubleValue() < this.lowerLimit.getValue()) {
            this.status.set((Enum)LimitStatus.BELOW_LIMIT);
        } else {
            this.status.set((Enum)LimitStatus.IN_RANGE);
        }
        return (LimitStatus)this.status.getEnumValue();
    }

    public LimitStatus getStatus() {
        return (LimitStatus)this.status.getEnumValue();
    }

    public double getDoubleValue() {
        return this.variableToCheck.getDoubleValue();
    }

    public String getName() {
        return this.variableToCheck.getName();
    }

    public static enum LimitStatus {
        IN_RANGE,
        BELOW_LIMIT,
        ABOVE_LIMIT;

    }
}

