/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.linearDynamicSystems;

import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.matrixlib.MatrixTools;
import us.ihmc.robotics.linearAlgebra.MatrixExponentialCalculator;
import us.ihmc.robotics.linearDynamicSystems.StateSpaceSystemDiscretizer;

public class SplitUpMatrixExponentialStateSpaceSystemDiscretizer
implements StateSpaceSystemDiscretizer {
    private final DMatrixRMaj discretizationMatrix1;
    private final MatrixExponentialCalculator matrixExponentialCalculator1;
    private final DMatrixRMaj discretizationMatrix2;
    private final MatrixExponentialCalculator matrixExponentialCalculator2;
    private final DMatrixRMaj F3;
    private final DMatrixRMaj G2;
    private final DMatrixRMaj G3;
    private final DMatrixRMaj negativeATranspose;
    private final int nStates;
    private final int nInputs;

    public SplitUpMatrixExponentialStateSpaceSystemDiscretizer(int numberOfStates, int numberOfInputs) {
        int discretizationMatrix1Size = numberOfStates + numberOfInputs;
        this.discretizationMatrix1 = new DMatrixRMaj(discretizationMatrix1Size, discretizationMatrix1Size);
        this.matrixExponentialCalculator1 = new MatrixExponentialCalculator(discretizationMatrix1Size);
        int discretizationMatrix2Size = 2 * numberOfStates;
        this.discretizationMatrix2 = new DMatrixRMaj(discretizationMatrix2Size, discretizationMatrix2Size);
        this.matrixExponentialCalculator2 = new MatrixExponentialCalculator(discretizationMatrix2Size);
        this.negativeATranspose = new DMatrixRMaj(numberOfStates, numberOfStates);
        this.F3 = new DMatrixRMaj(numberOfStates, numberOfStates);
        this.G2 = new DMatrixRMaj(numberOfStates, numberOfStates);
        this.G3 = new DMatrixRMaj(numberOfStates, numberOfInputs);
        this.nStates = numberOfStates;
        this.nInputs = numberOfInputs;
    }

    @Override
    public void discretize(DMatrixRMaj A, DMatrixRMaj B, DMatrixRMaj Q, double dt) {
        MatrixTools.checkMatrixDimensions((DMatrix1Row)A, (int)this.nStates, (int)this.nStates);
        MatrixTools.checkMatrixDimensions((DMatrix1Row)B, (int)this.nStates, (int)this.nInputs);
        MatrixTools.checkMatrixDimensions((DMatrix1Row)Q, (int)this.nStates, (int)this.nStates);
        CommonOps_DDRM.insert((DMatrix)A, (DMatrix)this.discretizationMatrix1, (int)0, (int)0);
        CommonOps_DDRM.insert((DMatrix)B, (DMatrix)this.discretizationMatrix1, (int)0, (int)this.nStates);
        CommonOps_DDRM.scale((double)dt, (DMatrixD1)this.discretizationMatrix1);
        this.matrixExponentialCalculator1.compute(this.discretizationMatrix1, this.discretizationMatrix1);
        CommonOps_DDRM.insert((DMatrix)A, (DMatrix)this.discretizationMatrix2, (int)this.nStates, (int)this.nStates);
        CommonOps_DDRM.transpose((DMatrixRMaj)A, (DMatrixRMaj)this.negativeATranspose);
        CommonOps_DDRM.changeSign((DMatrixD1)this.negativeATranspose);
        CommonOps_DDRM.insert((DMatrix)this.negativeATranspose, (DMatrix)this.discretizationMatrix2, (int)0, (int)0);
        CommonOps_DDRM.insert((DMatrix)Q, (DMatrix)this.discretizationMatrix2, (int)0, (int)this.nStates);
        CommonOps_DDRM.scale((double)dt, (DMatrixD1)this.discretizationMatrix2);
        this.matrixExponentialCalculator2.compute(this.discretizationMatrix2, this.discretizationMatrix2);
        CommonOps_DDRM.extract((DMatrix)this.discretizationMatrix1, (int)0, (int)this.nStates, (int)0, (int)this.nStates, (DMatrix)this.F3, (int)0, (int)0);
        CommonOps_DDRM.extract((DMatrix)this.discretizationMatrix2, (int)0, (int)this.nStates, (int)this.nStates, (int)(2 * this.nStates), (DMatrix)this.G2, (int)0, (int)0);
        CommonOps_DDRM.extract((DMatrix)this.discretizationMatrix1, (int)0, (int)this.nStates, (int)this.nStates, (int)(this.nStates + this.nInputs), (DMatrix)this.G3, (int)0, (int)0);
        A.set((DMatrixD1)this.F3);
        CommonOps_DDRM.mult((DMatrix1Row)this.F3, (DMatrix1Row)this.G3, (DMatrix1Row)B);
        CommonOps_DDRM.multTransA((DMatrix1Row)this.F3, (DMatrix1Row)this.G2, (DMatrix1Row)Q);
    }
}

